/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.network.task;

import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.network.task.SidedSystem;
import dev.ultreon.mods.xinexlib.Env;
import dev.ultreon.mods.xinexlib.network.Networker;
import dev.ultreon.mods.xinexlib.network.packet.PacketToClient;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class ResponsePacket
implements PacketToClient<ResponsePacket> {
    private final int id;
    private final Task request;
    private CompoundTag tag;

    public ResponsePacket(RegistryFriendlyByteBuf buf) {
        this.id = buf.readInt();
        boolean successful = buf.readBoolean();
        this.request = TaskManager.getTaskAndRemove(this.id);
        if (successful) {
            this.request.setSuccessful();
        }
        String name = buf.readUtf();
        this.request.setName(name);
        this.tag = buf.readNbt();
    }

    public ResponsePacket(int id, Task request) {
        this.id = id;
        this.request = request;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.request.isSuccessful());
        buf.writeUtf(this.request.getName());
        CompoundTag tag = new CompoundTag();
        this.request.prepareResponse((HolderLookup.Provider)buf.registryAccess(), tag);
        buf.writeNbt((Tag)tag);
    }

    public void handle(Networker networker) {
        this.request.processResponse(SidedSystem.getRegistryProvider(Env.CLIENT), this.tag);
        this.request.callback(this.tag);
    }
}

