/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.network.task;

import com.google.common.collect.ImmutableList;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.ApplicationManager;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.mods.xinexlib.network.Networker;
import dev.ultreon.mods.xinexlib.network.packet.PacketToClient;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class SyncApplicationPacket
implements PacketToClient<SyncApplicationPacket> {
    private final List<AppInfo> allowedApps;

    public SyncApplicationPacket(RegistryFriendlyByteBuf buf) {
        int size = buf.readInt();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            String appId = buf.readUtf();
            AppInfo info = ApplicationManager.getApplication(ResourceLocation.tryParse((String)appId));
            if (info != null) {
                builder.add((Object)info);
                continue;
            }
            UltreonDevices.LOGGER.error("Missing application '{}'", (Object)appId);
        }
        this.allowedApps = builder.build();
    }

    public SyncApplicationPacket(List<AppInfo> allowedApps) {
        this.allowedApps = allowedApps;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.allowedApps.size());
        for (AppInfo appInfo : this.allowedApps) {
            buf.writeResourceLocation(appInfo.getId());
        }
    }

    public void handle(Networker networker) {
        UltreonDevices.setAllowedApps(this.allowedApps);
    }
}

