/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.object;

import dev.ultreon.devices.object.Result;
import dev.ultreon.devices.programs.system.component.FileInfo;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Unit;

public class Picture {
    public int[] pixels;
    public Size size;
    private FileInfo source;
    private final String name;
    private String author = "Unknown";

    public Picture(String name, String author, Size size) {
        this.name = name;
        this.author = author;
        this.pixels = new int[size.width * size.height];
        this.size = size;
        this.init();
    }

    public Picture(FileInfo source) {
        this.name = source.getName();
        this.source = source;
        this.init();
    }

    public static Picture fromFile(FileInfo file) {
        return new Picture(file);
    }

    public void load(Consumer<Result<Picture>> callback) {
        callback.accept(Result.success(this));
    }

    private void init() {
        Arrays.fill(this.pixels, new Color(1.0f, 1.0f, 1.0f, 0.0f).getRGB());
    }

    public FileInfo getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getHeight() {
        return this.size.height;
    }

    public int getPixelWidth() {
        return this.size.pixelWidth;
    }

    public int getPixelHeight() {
        return this.size.pixelHeight;
    }

    public int[] copyPixels() {
        int[] copiedPixels = new int[this.pixels.length];
        System.arraycopy(this.pixels, 0, copiedPixels, 0, this.pixels.length);
        return copiedPixels;
    }

    public String toString() {
        return this.name;
    }

    public void writeToNBT(CompoundTag tagCompound) {
        tagCompound.putString("Name", this.getName());
        tagCompound.putString("Author", this.getAuthor());
        tagCompound.putIntArray("Pixels", this.pixels);
        tagCompound.putInt("Resolution", this.size.width);
    }

    public void writeToFile(FileInfo file, Consumer<Result<Unit>> callback) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bos);
        try {
            output.writeUTF(this.getName());
            output.writeUTF(this.getAuthor());
            output.writeInt(this.size.pixelWidth);
            output.writeInt(this.size.pixelHeight);
            output.writeInt(this.pixels.length);
            for (int pixel : this.pixels) {
                output.writeInt(pixel);
            }
            file.write(bos.toByteArray(), response -> {
                if (!response.success()) {
                    callback.accept(Result.failure(response.message()));
                }
                try {
                    bos.close();
                    callback.accept(Result.success(Unit.INSTANCE));
                }
                catch (IOException e) {
                    callback.accept(Result.failure(e.getMessage()));
                }
            });
        }
        catch (IOException e) {
            callback.accept(Result.failure(e.getMessage()));
        }
    }

    public static enum Size {
        X16(16, 16, 8, 8),
        X32(32, 32, 4, 4);

        public int width;
        public int height;
        public int pixelWidth;
        public int pixelHeight;

        private Size(int width, int height, int pixelWidth, int pixelHeight) {
            this.width = width;
            this.height = height;
            this.pixelWidth = pixelWidth;
            this.pixelHeight = pixelHeight;
        }

        public static Size getFromSize(int size) {
            if (size == 16) {
                return X16;
            }
            if (size == 32) {
                return X32;
            }
            return null;
        }
    }
}

