/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.object;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.object.Game;
import dev.ultreon.devices.object.tiles.Tile;
import dev.ultreon.devices.util.KeyboardHelper;
import dev.ultreon.devices.util.Vec2d;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class Player {
    private static final ResourceLocation boatTextures = ResourceLocation.parse((String)"textures/entity/boat/oak.png");
    boolean canMove = false;
    private final Game game;
    private double posX;
    private double posY;
    private double posXPrev;
    private double posYPrev;
    private double speed;
    private int rotation;
    private int rotationPrev;
    private final Vec2d direction;
    private final Vec2d velocity;
    private final BoatRenderer boatModel;
    private Boat boat;

    public static EntityRendererProvider.Context createEntityRendererContext() {
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher erd = mc.getEntityRenderDispatcher();
        return new EntityRendererProvider.Context(erd, mc.getItemRenderer(), mc.getBlockRenderer(), erd.getItemInHandRenderer(), mc.getResourceManager(), mc.getEntityModels(), mc.font);
    }

    public Player(Game game) {
        this.game = game;
        this.direction = new Vec2d(0.0, 0.0);
        this.velocity = new Vec2d(0.0, 0.0);
        this.boatModel = new BoatRenderer(Player.createEntityRendererContext(), false);
        assert (Minecraft.getInstance().player != null);
        boolean slim = Minecraft.getInstance().player.getSkin().model().equals((Object)PlayerSkin.Model.SLIM);
        if (!ComputerScreen.isWorldLess()) {
            this.boat = new Boat((Level)Objects.requireNonNull(Minecraft.getInstance().level), 0.0, 0.0, 0.0);
        }
    }

    public void tick() {
        Tile tile;
        this.rotationPrev = this.rotation;
        this.posXPrev = this.posX;
        this.posYPrev = this.posY;
        if (KeyboardHelper.isKeyDown(265)) {
            this.speed += 0.5;
            if (this.speed >= 3.0) {
                this.speed = 3.0;
            }
            if (KeyboardHelper.isKeyDown(42) || KeyboardHelper.isKeyDown(54)) {
                this.speed += 2.0;
            }
        } else {
            this.speed /= 1.1;
        }
        if (KeyboardHelper.isKeyDown(263)) {
            this.rotation -= 8;
        }
        if (KeyboardHelper.isKeyDown(262)) {
            this.rotation += 8;
        }
        if ((tile = this.game.getTile(Game.Layer.BACKGROUND, this.getPosX(), this.getPosY())) != null && tile.isSlow()) {
            this.speed *= 0.1;
        }
        this.direction.x = Math.cos(Math.toRadians(this.rotation));
        this.direction.y = Math.sin(Math.toRadians(this.rotation));
        this.direction.normalise();
        this.velocity.x = this.direction.x * this.speed;
        this.velocity.y = this.direction.y * this.speed;
        this.canMove = this.canMove();
        if (this.canMove) {
            this.posX += this.velocity.x;
            this.posY += this.velocity.y;
        } else {
            this.speed = 0.0;
        }
    }

    public boolean canMove() {
        if (this.posX + this.velocity.x <= 0.0) {
            return false;
        }
        if (this.posY + this.velocity.y <= 0.0) {
            return false;
        }
        if (this.posX + this.velocity.x >= (double)(this.game.mapWidth * 8)) {
            return false;
        }
        return !(this.posY + this.velocity.y >= (double)(this.game.mapHeight * 6));
    }

    public int getPosX() {
        return (int)(this.posX / 8.0);
    }

    public int getPosY() {
        return (int)(this.posY / 6.0);
    }

    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        float scale = 0.5f;
        double px = (double)x + this.posXPrev + (this.posX - this.posXPrev) * (double)partialTicks;
        double py = (double)y + this.posYPrev + (this.posY - this.posYPrev) * (double)partialTicks;
        float rot = (float)this.rotationPrev + (float)(this.rotation - this.rotationPrev) * partialTicks;
        graphics.pose().pushPose();
        graphics.pose().translate((float)px, (float)py, 3.0f);
        graphics.pose().scale(-scale, -scale, -scale);
        graphics.pose().mulPose(new Quaternionf(180.0f, 0.0f, 0.0f, 1.0f));
        graphics.pose().mulPose(new Quaternionf(90.0f, 1.0f, 0.0f, 0.0f));
        graphics.pose().translate(0.0, -3.0, 0.0);
        graphics.pose().mulPose(new Quaternionf(-90.0f, 1.0f, 0.0f, 0.0f));
        graphics.pose().mulPose(new Quaternionf(rot, 0.0f, 1.0f, 0.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)boatTextures);
        EntityRenderDispatcher entityRender = Minecraft.getInstance().getEntityRenderDispatcher();
        graphics.pose().popPose();
        graphics.pose().pushPose();
        graphics.pose().translate((float)px, (float)py, 3.0f);
        graphics.pose().scale(-scale, scale, scale);
        graphics.pose().mulPose(new Quaternionf(90.0f, 1.0f, 0.0f, 0.0f));
        graphics.pose().translate(0.0f, 5.0f, 0.0f);
        graphics.pose().mulPose(new Quaternionf(90.0f, 1.0f, 0.0f, 0.0f));
        graphics.pose().mulPose(new Quaternionf(180.0f, 0.0f, 0.0f, 1.0f));
        graphics.pose().mulPose(new Quaternionf(rot - 90.0f, 0.0f, 1.0f, 0.0f));
        graphics.pose().translate(0.0f, -12.0f, 5.0f);
        graphics.pose().popPose();
    }
}

