/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.object;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.api.app.listener.ClickListener;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.object.Game;
import dev.ultreon.devices.object.tiles.Tile;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class TileGrid
extends Component {
    private Label labelCurrentCategory;
    private Button btnNextCategory;
    private Button btnPrevCategory;
    private int currentCategory = 0;
    private List<Tile> tabTiles = new ArrayList<Tile>();
    private Game game;

    public TileGrid(int left, int top, Game game) {
        super(left, top);
        this.game = game;
    }

    @Override
    public void init(Layout layout) {
        this.labelCurrentCategory = new Label("", this.left + 14, this.top + 2);
        layout.addComponent(this.labelCurrentCategory);
        this.btnNextCategory = new Button(this.left + 81, this.top, Icons.CHEVRON_RIGHT);
        this.btnNextCategory.setPadding(1);
        this.btnNextCategory.setClickListener(new ClickListener(){

            @Override
            public void onClick(int mouseX, int mouseY, int mouseButton) {
                if (TileGrid.this.currentCategory < Tile.Category.values().length - 1) {
                    ++TileGrid.this.currentCategory;
                    TileGrid.this.updateTiles();
                }
            }
        });
        layout.addComponent(this.btnNextCategory);
        this.btnPrevCategory = new Button(this.left, this.top, Icons.CHEVRON_LEFT);
        this.btnPrevCategory.setPadding(1);
        this.btnPrevCategory.setClickListener(new ClickListener(){

            @Override
            public void onClick(int mouseX, int mouseY, int mouseButton) {
                if (TileGrid.this.currentCategory > 0) {
                    --TileGrid.this.currentCategory;
                    TileGrid.this.updateTiles();
                }
            }
        });
        layout.addComponent(this.btnPrevCategory);
        this.updateTiles();
    }

    @Override
    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        int i;
        graphics.fill(this.xPosition, this.yPosition + 15, this.xPosition + 93, this.yPosition + 100, Color.DARK_GRAY.getRGB());
        graphics.fill(this.xPosition + 1, this.yPosition + 16, this.xPosition + 92, this.yPosition + 99, Color.GRAY.getRGB());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Game.ICONS);
        for (i = 0; i < this.tabTiles.size(); ++i) {
            Tile tile = this.tabTiles.get(i);
            int tileX = i % 6 * 15 + this.xPosition + 3;
            int tileY = i / 6 * 15 + this.yPosition + 18;
            if (GuiHelper.isMouseInside(mouseX, mouseY, tileX - 1, tileY - 1, tileX + 12, tileY + 12) || this.game.getCurrentTile() == tile) {
                graphics.fill(tileX - 1, tileY - 1, tileX + 13, tileY + 13, Color.WHITE.getRGB());
            } else {
                graphics.fill(tileX - 1, tileY - 1, tileX + 13, tileY + 13, Color.LIGHT_GRAY.getRGB());
            }
            graphics.pose().pushPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.drawRectWithTexture(null, graphics, tileX, tileY, tile.x * 16, tile.y * 16, 12, 12, 16.0f, 16.0f);
            graphics.pose().popPose();
        }
        if (GuiHelper.isMouseInside(mouseX, mouseX, this.xPosition, this.yPosition, this.xPosition + 60, this.yPosition + 60)) {
            for (i = 0; i < this.tabTiles.size(); ++i) {
                int tileX = i % 6 * 15 + this.xPosition + 2;
                int tileY = i / 6 * 15 + this.yPosition + 17;
                if (!GuiHelper.isMouseInside(mouseX, mouseY, tileX, tileY, tileX + 14, tileY + 14)) continue;
                graphics.fill(tileX - 1, tileY - 1, tileX + 13, tileY + 13, Color.WHITE.getRGB());
            }
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        for (int i = 0; i < this.tabTiles.size(); ++i) {
            int x = i % 6 * 15 + this.xPosition + 3;
            int y = i / 6 * 15 + this.yPosition + 18;
            if (!GuiHelper.isMouseInside(mouseX, mouseY, x - 1, y - 1, x + 12, y + 12)) continue;
            this.game.setCurrentTile(this.tabTiles.get(i));
            return;
        }
    }

    public void updateTiles() {
        this.tabTiles.clear();
        Tile.Category category = Tile.Category.values()[this.currentCategory];
        this.labelCurrentCategory.setText(category.name);
        for (Tile tile : Game.getRegisteredtiles().values()) {
            if (tile.getCategory() != category) continue;
            this.tabTiles.add(tile);
        }
    }
}

