/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.object.tiles;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.object.Game;
import dev.ultreon.devices.object.tiles.Tile;
import net.minecraft.client.gui.GuiGraphics;

public class TileBlock
extends Tile {
    public TileBlock(int id, int x, int y) {
        super(id, x, y);
    }

    public TileBlock(int id, int x, int y, int topX, int topY) {
        super(id, x, y, topX, topY);
    }

    @Override
    public void render(GuiGraphics graphics, Game game, int x, int y, Game.Layer layer) {
        if (layer == Game.Layer.BACKGROUND) {
            super.render(graphics, game, x, y, layer);
            if (!game.isFullTile(layer, x, y + 1) && this != Tile.water) {
                RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
                RenderUtil.drawRectWithTexture(null, graphics, (double)(game.xPosition + x * 8), (double)(game.yPosition + y * 6 + 6), layer.zLevel, (float)(this.x * 16), (float)(this.y * 16), 8, 2, 16.0f, 4.0f);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            return;
        }
        if (game.getTile(layer.up(), x, y - 1) != this || layer == Game.Layer.FOREGROUND) {
            RenderUtil.drawRectWithTexture(null, graphics, (double)(game.xPosition + x * 8), (double)(game.yPosition + y * 6 - 6), layer.zLevel, (float)(this.topX * 16), (float)(this.topY * 16), 8, 6, 16.0f, 16.0f);
        }
        RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        RenderUtil.drawRectWithTexture(null, graphics, (double)(game.xPosition + x * 8), (double)(game.yPosition + y * 6), layer.zLevel, (float)(this.x * 16), (float)(this.y * 16), 8, 6, 16.0f, 16.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void renderForeground(GuiGraphics graphics, Game game, int x, int y, Game.Layer layer) {
        if (layer != Game.Layer.BACKGROUND || this == Tile.water) {
            return;
        }
        Tile tileDown = game.getTile(layer, x, y + 1);
        if (game.getTile(layer, x, y + 1) == Tile.water) {
            RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
            RenderUtil.drawRectWithTexture(null, graphics, (double)(game.xPosition + x * 8), (double)(game.yPosition + y * 6 + 6), layer.zLevel, (float)(this.x * 16), (float)(this.y * 16), 8, 1, 16.0f, 2.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

