/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.ItemList;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.api.app.component.Text;
import dev.ultreon.devices.api.app.component.TextArea;
import dev.ultreon.devices.api.app.component.TextField;
import dev.ultreon.devices.api.io.Drive;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.programs.system.component.FileInfo;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Unit;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NoteStashApp
extends Application {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"Note Stash App");
    private Layout layoutMain;
    private ItemList<Note> notes;
    private Button btnNew;
    private Button btnView;
    private Button btnDelete;
    private Layout layoutAddNote;
    private TextField title;
    private TextArea textArea;
    private Button btnSave;
    private Button btnCancel;
    private Layout layoutViewNote;
    private Label noteTitle;
    private Text noteContent;
    private Button btnBack;

    @Override
    public void init(@Nullable CompoundTag intent) {
        this.layoutMain = new Layout(180, 80);
        this.layoutMain.setInitListener(() -> {
            this.notes.getItems().clear();
            this.notes.setLoading(true);
            UltreonDevices.LOGGER.debug(MARKER, "Loading notes...");
            FileSystem.getApplicationFolder(this, response -> ((FileInfo)response.data()).child("notes.json", response2 -> {
                if (response2.success()) {
                    FileInfo fileInfo = (FileInfo)response2.data();
                    fileInfo.read(response3 -> {
                        if (response3.success()) {
                            byte[] data = (byte[])response3.data();
                            List<String> lines = new String(data, StandardCharsets.UTF_8).lines().toList();
                            for (String line : lines) {
                                String[] split = line.split(",", 2);
                                if (split.length != 2) continue;
                                this.notes.addItem(new Note(split[0], null, Path.of(split[1]), null));
                            }
                            this.notes.setLoading(false);
                        }
                    });
                }
            }));
        });
        this.notes = new ItemList(5, 5, 100, 5);
        this.notes.setItemClickListener((e, index, mouseButton) -> {
            this.btnView.setEnabled(true);
            this.btnDelete.setEnabled(true);
        });
        this.layoutMain.addComponent(this.notes);
        this.btnNew = new Button(124, 5, "New");
        this.btnNew.setSize(50, 20);
        this.btnNew.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutAddNote));
        this.layoutMain.addComponent(this.btnNew);
        this.btnView = new Button(124, 30, "View");
        this.btnView.setSize(50, 20);
        this.btnView.setEnabled(false);
        this.btnView.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.notes.getSelectedIndex() != -1) {
                Note note = this.notes.getSelectedItem();
                assert (note != null);
                this.noteTitle.setText(note.getTitle());
                note.getContent((content, success) -> {
                    if (success) {
                        this.noteContent.setText((String)content);
                    } else {
                        Dialog.Message message = new Dialog.Message("Failed to load note!");
                        message.setTitle("Error");
                        this.openDialog(message);
                    }
                });
                this.setCurrentLayout(this.layoutViewNote);
            } else {
                this.btnView.setEnabled(false);
            }
        });
        this.layoutMain.addComponent(this.btnView);
        this.btnDelete = new Button(124, 55, "Delete");
        this.btnDelete.setSize(50, 20);
        this.btnDelete.setEnabled(false);
        this.btnDelete.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.notes.getSelectedIndex() != -1) {
                Note note = this.notes.getSelectedItem();
                assert (note != null);
                Path file = note.getSource();
                Drive drive = note.drive;
                if (file != null) {
                    drive.delete(file, response -> {
                        if (response.success()) {
                            this.notes.removeItem(this.notes.getSelectedIndex());
                            this.btnView.setEnabled(false);
                            this.btnDelete.setEnabled(false);
                        } else {
                            Dialog.Message message = new Dialog.Message(response.message());
                            message.setTitle("I/O Error");
                            this.openDialog(message);
                        }
                    });
                }
            }
        });
        this.layoutMain.addComponent(this.btnDelete);
        this.layoutAddNote = new Layout(180, 80);
        this.title = new TextField(5, 5, 114);
        this.layoutAddNote.addComponent(this.title);
        this.textArea = new TextArea(5, 25, 114, 50);
        this.textArea.setFocused(true);
        this.textArea.setPadding(2);
        this.layoutAddNote.addComponent(this.textArea);
        this.btnSave = new Button(124, 5, "Save");
        this.btnSave.setSize(50, 20);
        this.btnSave.setClickListener((mouseX, mouseY, mouseButton) -> {
            CompoundTag data = new CompoundTag();
            data.putString("title", this.title.getText());
            data.putString("content", this.textArea.getText());
            FileSystem.getApplicationFolder(this, response -> {
                if (!response.success()) {
                    UltreonDevices.LOGGER.error(MARKER, "Failed to get application folder: {}", (Object)response.message());
                    Dialog.Message message = new Dialog.Message("Failed to get app directory, report the log to the developers.");
                    this.openDialog(message);
                }
            });
            Dialog.SaveFile dialog = new Dialog.SaveFile(this);
            dialog.setFolder(this.getApplicationFolderPath());
            dialog.setResponseHandler((success, file) -> {
                FileInfo info = file.withExtension(".note");
                String text = this.title.getText() + "\u0000" + this.textArea.getText();
                info.write(text.getBytes(StandardCharsets.UTF_8), response -> {
                    if (response.success()) {
                        Note note = new Note(this.title.getText(), info, this.textArea.getText());
                        this.notes.addItem(note);
                        this.title.clear();
                        this.textArea.clear();
                        this.setCurrentLayout(this.layoutMain);
                    } else {
                        Dialog.Message message = new Dialog.Message("Failed to save note:\n" + response.message());
                        this.openDialog(message);
                    }
                });
                this.title.clear();
                this.textArea.clear();
                this.setCurrentLayout(this.layoutMain);
                return true;
            });
            this.openDialog(dialog);
        });
        this.layoutAddNote.addComponent(this.btnSave);
        this.btnCancel = new Button(124, 30, "Cancel");
        this.btnCancel.setSize(50, 20);
        this.btnCancel.setClickListener((mouseX, mouseY, mouseButton) -> {
            this.title.clear();
            this.textArea.clear();
            this.setCurrentLayout(this.layoutMain);
        });
        this.layoutAddNote.addComponent(this.btnCancel);
        this.layoutViewNote = new Layout(180, 80);
        this.noteTitle = new Label("", 5, 5);
        this.layoutViewNote.addComponent(this.noteTitle);
        this.noteContent = new Text("", 5, 18, 110);
        this.layoutViewNote.addComponent(this.noteContent);
        this.btnBack = new Button(124, 5, "Back");
        this.btnBack.setSize(50, 20);
        this.btnBack.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutMain));
        this.layoutViewNote.addComponent(this.btnBack);
        this.setCurrentLayout(this.layoutMain);
    }

    @Override
    public void load(CompoundTag tagCompound) {
    }

    @Override
    public void save(CompoundTag tagCompound) {
    }

    @Override
    public void onClose() {
        super.onClose();
        this.notes.removeAll();
    }

    @Override
    public boolean handleFile(FileInfo file, Callback<Unit> callback) {
        if (!file.getName().endsWith(".note")) {
            return false;
        }
        Note note = Note.fromFile(file);
        note.getContent((content, success) -> {
            if (!success) {
                callback.execute(null, false);
                return;
            }
            this.noteTitle.setText(note.getTitle());
            this.noteContent.setText((String)content);
            this.setCurrentLayout(this.layoutViewNote);
            callback.execute(Unit.INSTANCE, true);
        });
        return true;
    }

    private static class Note {
        private final String title;
        private FileInfo file;
        private Drive drive;
        private Path source;
        @Nullable
        private final String content;

        public Note(String title, Drive drive, Path source, @Nullable String content) {
            this.title = title;
            this.drive = drive;
            this.source = source;
            this.content = content;
        }

        public Note(String title, FileInfo file, String content) {
            this.title = title;
            this.file = file;
            this.content = content;
        }

        public static Note fromFile(FileInfo file) {
            return new Note(file.getName(), file, null);
        }

        public Path getSource() {
            return this.source;
        }

        public String getTitle() {
            return this.title;
        }

        public void getContent(Callback<String> callback) {
            if (this.content == null) {
                this.loadContent(callback);
                return;
            }
            callback.execute(this.content, true);
        }

        private void loadContent(Callback<String> callback) {
            this.drive.read(this.source, response -> {
                if (!response.success()) {
                    callback.execute("", false);
                    return;
                }
                callback.execute(new String((byte[])response.data(), StandardCharsets.UTF_8), true);
            });
        }

        public String toString() {
            return this.title;
        }
    }
}

