/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.auction;

import dev.ultreon.devices.programs.auction.object.AuctionItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class AuctionManager {
    public static final AuctionManager INSTANCE = new AuctionManager();
    private final List<AuctionItem> items = new ArrayList<AuctionItem>();

    private AuctionManager() {
    }

    public void addItem(AuctionItem item) {
        if (!this.containsItem(item.getId())) {
            this.items.add(item);
        }
    }

    public boolean containsItem(UUID id) {
        for (AuctionItem item : this.items) {
            if (!item.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public AuctionItem getItem(UUID uuid) {
        for (AuctionItem item : this.items) {
            if (!item.getId().equals(uuid)) continue;
            return item;
        }
        return null;
    }

    public void removeItem(UUID uuid) {
        for (AuctionItem item : this.items) {
            if (!item.getId().equals(uuid)) continue;
            this.items.remove(item);
            return;
        }
    }

    public List<AuctionItem> getItems() {
        return this.items;
    }

    public void tick() {
        for (AuctionItem item : this.items) {
            item.decrementTime();
        }
    }

    public void writeToNBT(HolderLookup.Provider provider, CompoundTag tag) {
        ListTag tagList = new ListTag();
        this.items.stream().filter(AuctionItem::isValid).forEach(i -> {
            CompoundTag itemTag = new CompoundTag();
            i.writeToNBT(itemTag, provider);
            tagList.add((Object)itemTag);
        });
        tag.put("auctionItems", (Tag)tagList);
    }

    public void readFromNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.items.clear();
        ListTag tagList = (ListTag)tag.get("auctionItems");
        if (tagList != null) {
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTag = tagList.getCompound(i);
                AuctionItem item = AuctionItem.readFromNBT(provider, itemTag);
                this.items.add(item);
            }
        }
    }

    public List<AuctionItem> getItemsForSeller(UUID seller) {
        return this.items.stream().filter(i -> i.getSellerId().equals(seller)).collect(Collectors.toList());
    }
}

