/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.auction.object;

import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class AuctionItem {
    private final UUID id;
    private final ItemStack stack;
    private final int price;
    private long timeLeft;
    private final UUID sellerId;

    public AuctionItem(ItemStack stack, int price, long timeLeft, UUID sellerId) {
        this.id = UUID.randomUUID();
        this.stack = stack;
        this.price = price;
        this.timeLeft = timeLeft;
        this.sellerId = sellerId;
    }

    public AuctionItem(UUID id, ItemStack stack, int price, long timeLeft, UUID sellerId) {
        this.id = id;
        this.stack = stack;
        this.price = price;
        this.timeLeft = timeLeft;
        this.sellerId = sellerId;
    }

    public static AuctionItem readFromNBT(HolderLookup.Provider provider, CompoundTag tag) {
        UUID id = UUID.fromString(tag.getString("id"));
        CompoundTag item = tag.getCompound("item");
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)item);
        int price = tag.getInt("price");
        long timeLeft = tag.getLong("time");
        UUID sellerId = UUID.fromString(tag.getString("seller"));
        return new AuctionItem(id, stack, price, timeLeft, sellerId);
    }

    public UUID getId() {
        return this.id;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public int getPrice() {
        return this.price;
    }

    public UUID getSellerId() {
        return this.sellerId;
    }

    public boolean isValid() {
        return this.timeLeft > 0L;
    }

    public void decrementTime() {
        if (this.timeLeft > 0L) {
            --this.timeLeft;
        }
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    public void setSold() {
        this.timeLeft = 0L;
    }

    public void writeToNBT(CompoundTag tag, HolderLookup.Provider access) {
        tag.putString("id", this.id.toString());
        CompoundTag item = new CompoundTag();
        item = this.stack.save(access, (Tag)item);
        tag.put("item", (Tag)item);
        tag.putInt("price", this.price);
        tag.putLong("time", this.timeLeft);
        tag.putString("seller", this.sellerId.toString());
    }

    public String toString() {
        return "{ " + String.valueOf(this.id) + ", " + String.valueOf(this.stack) + ", " + this.price + ", " + this.timeLeft + ", " + String.valueOf(this.sellerId) + " }";
    }
}

