/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.auction.task;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.programs.auction.AuctionManager;
import dev.ultreon.devices.programs.auction.object.AuctionItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TaskAddAuction
extends Task {
    private int slot;
    private int amount;
    private int price;
    private int duration;
    private AuctionItem item;

    public TaskAddAuction() {
    }

    public TaskAddAuction(int slot, int amount, int price, int duration) {
        this();
        this.slot = slot;
        this.amount = amount;
        this.price = price;
        this.duration = duration;
    }

    @Override
    public void prepareRequest(HolderLookup.Provider provider, CompoundTag nbt) {
        nbt.putInt("slot", this.slot);
        nbt.putInt("amount", this.amount);
        nbt.putInt("price", this.price);
        nbt.putInt("duration", this.duration);
    }

    @Override
    public void processRequest(HolderLookup.Provider provider, CompoundTag nbt, Level level, Player player) {
        ItemStack real;
        int slot = nbt.getInt("slot");
        int amount = nbt.getInt("amount");
        int price = nbt.getInt("price");
        int duration = nbt.getInt("duration");
        if (slot >= 0 && price >= 0 && slot < player.getInventory().getContainerSize() && !(real = player.getInventory().getItem(slot)).isEmpty()) {
            ItemStack stack = real.copy();
            stack.setCount(amount);
            real.shrink(amount);
            this.item = new AuctionItem(stack, price, duration, player.getUUID());
            AuctionManager.INSTANCE.addItem(this.item);
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(HolderLookup.Provider provider, CompoundTag nbt) {
        if (this.isSuccessful()) {
            this.item.writeToNBT(nbt, (HolderLookup.Provider)UltreonDevices.getServer().registryAccess());
        }
    }

    @Override
    public void processResponse(HolderLookup.Provider provider, CompoundTag nbt) {
        if (this.isSuccessful()) {
            AuctionManager.INSTANCE.addItem(AuctionItem.readFromNBT(provider, nbt));
        }
    }
}

