/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.auction.task;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.programs.auction.AuctionManager;
import dev.ultreon.devices.programs.auction.object.AuctionItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TaskGetAuctions
extends Task {
    private UUID seller;

    public TaskGetAuctions() {
    }

    public TaskGetAuctions(UUID seller) {
        this();
        this.seller = seller;
    }

    @Override
    public void prepareRequest(HolderLookup.Provider provider, CompoundTag nbt) {
        if (this.seller != null) {
            nbt.putString("seller", this.seller.toString());
        }
    }

    @Override
    public void processRequest(HolderLookup.Provider provider, CompoundTag nbt, Level world, Player player) {
        if (nbt.contains("seller")) {
            this.seller = UUID.fromString(nbt.getString("seller"));
        }
    }

    @Override
    public void prepareResponse(HolderLookup.Provider provider, CompoundTag nbt) {
        if (this.seller != null) {
            List<AuctionItem> items = AuctionManager.INSTANCE.getItemsForSeller(this.seller);
            ListTag tagList = new ListTag();
            items.forEach(i -> {
                CompoundTag itemTag = new CompoundTag();
                i.writeToNBT(itemTag, (HolderLookup.Provider)UltreonDevices.getServer().registryAccess());
                tagList.add((Object)itemTag);
            });
            nbt.put("auctionItems", (Tag)tagList);
        } else {
            AuctionManager.INSTANCE.writeToNBT(provider, nbt);
        }
        this.setSuccessful();
    }

    @Override
    public void processResponse(HolderLookup.Provider provider, CompoundTag nbt) {
        AuctionManager.INSTANCE.readFromNBT(provider, nbt);
    }
}

