/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.email;

import com.google.common.collect.HashBiMap;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.WorldSavedData;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Notification;
import dev.ultreon.devices.programs.email.object.Email;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class EmailManager
implements WorldSavedData {
    public static final EmailManager INSTANCE = new EmailManager();
    private final HashBiMap<UUID, String> uuidToName = HashBiMap.create();
    private final Map<String, List<Email>> nameToInbox = new HashMap<String, List<Email>>();
    private List<Email> inbox;

    public boolean addEmailToInbox(Email email, String to) {
        if (this.nameToInbox.containsKey(to)) {
            this.nameToInbox.get(to).add(0, email);
            this.sendNotification(to, email);
            return true;
        }
        return false;
    }

    public List<Email> getInbox() {
        if (this.inbox == null) {
            this.inbox = new ArrayList<Email>();
        }
        return this.inbox;
    }

    public List<Email> getEmailsForAccount(Player player) {
        if (this.uuidToName.containsKey((Object)player.getUUID())) {
            return this.nameToInbox.get(this.uuidToName.get((Object)player.getUUID()));
        }
        return new ArrayList<Email>();
    }

    public boolean addAccount(Player player, String name) {
        if (!this.uuidToName.containsKey((Object)player.getUUID()) && !this.uuidToName.containsValue((Object)name)) {
            this.uuidToName.put((Object)player.getUUID(), (Object)name);
            this.nameToInbox.put(name, new ArrayList());
            return true;
        }
        return false;
    }

    public boolean hasAccount(UUID uuid) {
        return this.uuidToName.containsKey((Object)uuid);
    }

    public String getName(Player player) {
        return (String)this.uuidToName.get((Object)player.getUUID());
    }

    @Override
    public void load(CompoundTag nbt) {
        this.nameToInbox.clear();
        ListTag inboxes = (ListTag)nbt.get("Inboxes");
        for (int i = 0; i < inboxes.size(); ++i) {
            CompoundTag inbox = inboxes.getCompound(i);
            String name = inbox.getString("Name");
            ArrayList<Email> emails = new ArrayList<Email>();
            ListTag emailTagList = (ListTag)inbox.get("Emails");
            for (int j = 0; j < emailTagList.size(); ++j) {
                CompoundTag emailTag = emailTagList.getCompound(j);
                Email email = Email.readFromNBT(emailTag);
                emails.add(email);
            }
            this.nameToInbox.put(name, emails);
        }
        this.uuidToName.clear();
        ListTag accounts = (ListTag)nbt.get("Accounts");
        for (int i = 0; i < accounts.size(); ++i) {
            CompoundTag account = accounts.getCompound(i);
            UUID uuid = UUID.fromString(account.getString("UUID"));
            String name = account.getString("Name");
            this.uuidToName.put((Object)uuid, (Object)name);
        }
    }

    @Override
    public void save(CompoundTag nbt) {
        ListTag inboxes = new ListTag();
        for (String key : this.nameToInbox.keySet()) {
            CompoundTag inbox = new CompoundTag();
            inbox.putString("Name", key);
            ListTag emailTagList = new ListTag();
            List<Email> emails = this.nameToInbox.get(key);
            for (Email email : emails) {
                CompoundTag emailTag = new CompoundTag();
                email.save(emailTag);
                emailTagList.add((Object)emailTag);
            }
            inbox.put("Emails", (Tag)emailTagList);
            inboxes.add((Object)inbox);
        }
        nbt.put("Inboxes", (Tag)inboxes);
        ListTag accounts = new ListTag();
        for (UUID key : this.uuidToName.keySet()) {
            CompoundTag account = new CompoundTag();
            account.putString("UUID", key.toString());
            account.putString("Name", Objects.requireNonNull((String)this.uuidToName.get((Object)key)));
            accounts.add((Object)account);
        }
        nbt.put("Accounts", (Tag)accounts);
    }

    public void clear() {
        this.nameToInbox.clear();
        this.uuidToName.clear();
        this.inbox.clear();
    }

    private void sendNotification(String name, Email email) {
        ServerPlayer player;
        MinecraftServer server = UltreonDevices.getServer();
        UUID id = (UUID)this.uuidToName.inverse().get((Object)name);
        if (id != null && (player = server.getPlayerList().getPlayer(id)) != null) {
            Notification notification = new Notification(Icons.MAIL, "New Email!", "from " + email.getAuthor());
            notification.pushTo(player);
        }
    }
}

