/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.email.object;

import dev.ultreon.devices.programs.email.AttachedFile;
import net.minecraft.nbt.CompoundTag;

public class Email {
    private final String subject;
    private String author;
    private final String message;
    private final AttachedFile attachment;
    private boolean read;

    public Email(String subject, String message, AttachedFile file) {
        this.subject = subject;
        this.message = message;
        this.attachment = file;
        this.read = false;
    }

    public Email(String subject, String author, String message, AttachedFile attachment) {
        this(subject, message, attachment);
        this.author = author;
    }

    public static Email readFromNBT(CompoundTag nbt) {
        AttachedFile attachment = null;
        if (nbt.contains("attachment", 10)) {
            attachment = AttachedFile.fromTag(nbt.getCompound("attachment"));
        }
        Email email = new Email(nbt.getString("subject"), nbt.getString("author"), nbt.getString("message"), attachment);
        email.setRead(nbt.getBoolean("read"));
        return email;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMessage() {
        return this.message;
    }

    public AttachedFile getAttachment() {
        return this.attachment;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public void save(CompoundTag nbt) {
        nbt.putString("subject", this.subject);
        if (this.author != null) {
            nbt.putString("author", this.author);
        }
        nbt.putString("message", this.message);
        nbt.putBoolean("read", this.read);
        if (this.attachment != null) {
            nbt.put("attachment", this.attachment.toTag());
        }
    }
}

