/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.gitweb.component.container;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.programs.gitweb.component.container.ContainerBox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class BrewingBox
extends ContainerBox {
    public static final int HEIGHT = 73;
    private static final int[] BUBBLELENGTHS = new int[]{28, 24, 20, 16, 11, 6, 0};
    private int brewTimer;

    public BrewingBox(ItemStack fuel, ItemStack input, ItemStack[] output) {
        super(0, 0, 0, 136, 73, new ItemStack((ItemLike)Items.BREWING_STAND), "Brewing Stand");
        this.slots.add(new ContainerBox.Slot(14, 8, fuel));
        this.slots.add(new ContainerBox.Slot(75, 8, input));
        this.setOutput(output);
    }

    private void setOutput(ItemStack[] output) {
        if (output.length > 0) {
            this.slots.add(new ContainerBox.Slot(52, 42, output[0]));
        }
        if (output.length > 1) {
            this.slots.add(new ContainerBox.Slot(75, 49, output[1]));
        }
        if (output.length > 2) {
            this.slots.add(new ContainerBox.Slot(98, 42, output[1]));
        }
    }

    @Override
    protected void handleTick() {
        if (--this.brewTimer < 0) {
            this.brewTimer = 400;
        }
    }

    @Override
    protected void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        super.render(graphics, computerScreen, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONTAINER_BOXES_TEXTURE);
        graphics.blit(CONTAINER_BOXES_TEXTURE, x + 56, y + 47, 152, 252, 18, 4);
        if (this.brewTimer > 0 && this.slots.size() > 1 && !((ContainerBox.Slot)this.slots.get(1)).getStack().isEmpty()) {
            int scaledPercent = (int)(28.0f * (1.0f - (float)this.brewTimer / 400.0f));
            if (scaledPercent > 0) {
                graphics.blit(CONTAINER_BOXES_TEXTURE, x + 93, y + 19, 152, 223, 9, scaledPercent);
            }
            if ((scaledPercent = BUBBLELENGTHS[this.brewTimer / 2 % 7]) > 0) {
                graphics.blit(CONTAINER_BOXES_TEXTURE, x + 59, y + 16 + 29 - scaledPercent, 161, 251 - scaledPercent, 12, scaledPercent);
            }
        }
    }
}

