/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.gitweb.component.container;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class ContainerBox
extends Component {
    public static final int WIDTH = 128;
    protected static final ResourceLocation CONTAINER_BOXES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"devices", (String)"textures/gui/container_boxes.png");
    protected List<Slot> slots = new ArrayList<Slot>();
    protected int boxU;
    protected int boxV;
    protected int height;
    protected ItemStack icon;
    protected String title;

    public ContainerBox(int left, int top, int boxU, int boxV, int height, ItemStack icon, String title) {
        super(left, top);
        this.boxU = boxU;
        this.boxV = boxV;
        this.height = height;
        this.icon = icon;
        this.title = title;
    }

    @Override
    protected void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONTAINER_BOXES_TEXTURE);
        RenderUtil.drawRectWithTexture(CONTAINER_BOXES_TEXTURE, graphics, (double)x, (double)(y + 12), (float)this.boxU, (float)this.boxV, 128, this.height, 128.0f, (float)this.height, 256, 256);
        int contentOffset = (128 - (ComputerScreen.getFont().width(this.title) + 8 + 4)) / 2;
        graphics.pose().pushPose();
        graphics.pose().translate((float)(x + contentOffset), (float)y, 0.0f);
        graphics.pose().scale(0.5f, 0.5f, 0.5f);
        RenderUtil.renderItem(graphics, x + contentOffset - 5, y - 4, this.icon, false);
        graphics.pose().popPose();
        RenderUtil.drawStringClipped(graphics, this.title, x + contentOffset + 8 + 4, y, 110, Color.WHITE.getRGB(), true);
        this.slots.forEach(slot -> slot.render(graphics, x, y + 12));
    }

    @Override
    protected void renderOverlay(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int mouseX, int mouseY, boolean windowActive) {
        this.slots.forEach(slot -> slot.renderOverlay(graphics, computerScreen, this.xPosition, this.yPosition + 12, mouseX, mouseY));
    }

    protected static class Slot {
        private final int slotX;
        private final int slotY;
        private final ItemStack stack;

        public Slot(int slotX, int slotY, ItemStack stack) {
            this.slotX = slotX;
            this.slotY = slotY;
            this.stack = stack;
        }

        public void render(GuiGraphics graphics, int x, int y) {
            RenderUtil.renderItem(graphics, x + this.slotX, y + this.slotY, this.stack, true);
        }

        public void renderOverlay(GuiGraphics graphics, ComputerScreen computerScreen, int x, int y, int mouseX, int mouseY) {
            if (GuiHelper.isMouseWithin(mouseX, mouseY, x + this.slotX, y + this.slotY, 16, 16) && !this.stack.isEmpty()) {
                graphics.renderTooltip(Minecraft.getInstance().font, Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)this.stack), Optional.empty(), mouseX, mouseY);
            }
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

