/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.gitweb.component.container;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.programs.gitweb.component.container.ContainerBox;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class LoomBox
extends ContainerBox {
    public static final int HEIGHT = 84;
    private final ItemStack result;
    private final BannerPatternLayers resultBannerPatterns;
    private final ModelPart flag;

    public LoomBox(ItemStack banner, ItemStack dye, ItemStack pattern, ItemStack result) {
        super(0, 0, 128, 72, 84, new ItemStack((ItemLike)Blocks.LOOM), "Loom");
        this.result = result;
        this.slots.add(new ContainerBox.Slot(13, 26, banner));
        this.slots.add(new ContainerBox.Slot(33, 26, dye));
        this.slots.add(new ContainerBox.Slot(23, 45, pattern));
        this.slots.add(new ContainerBox.Slot(94, 58, this.result));
        this.resultBannerPatterns = !result.isEmpty() ? (BannerPatternLayers)result.get(DataComponents.BANNER_PATTERNS) : new BannerPatternLayers(new ArrayList());
        this.flag = Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BANNER).getChild("flag");
    }

    @Override
    protected void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        super.render(graphics, computerScreen, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
        int j = y + 12;
        if (this.result.isEmpty()) {
            return;
        }
        Lighting.setupForFlatItems();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        graphics.pose().pushPose();
        graphics.pose().translate((double)x + 90.0, (double)j + 52.0, 0.0);
        graphics.pose().scale(24.0f, -24.0f, 1.0f);
        graphics.pose().translate(0.5, 0.5, 0.5);
        float f = 0.6666667f;
        graphics.pose().scale(0.6666667f, -0.6666667f, -0.6666667f);
        this.flag.xRot = 0.0f;
        this.flag.y = -32.0f;
        BannerRenderer.renderPatterns((PoseStack)graphics.pose(), (MultiBufferSource)bufferSource, (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.flag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)DyeColor.WHITE, (BannerPatternLayers)this.resultBannerPatterns);
        graphics.pose().popPose();
        bufferSource.endBatch();
    }
}

