/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.gitweb.module;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.programs.gitweb.component.GitWebFrame;
import dev.ultreon.devices.programs.gitweb.module.ContainerModule;
import dev.ultreon.devices.programs.gitweb.module.Module;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class BannerIIModule
extends Module {
    @Override
    public String[] getRequiredData() {
        return new String[]{"banner"};
    }

    @Override
    public String[] getOptionalData() {
        return new String[]{"waving"};
    }

    @Override
    public int calculateHeight(Map<String, String> data, int width) {
        return 84;
    }

    @Override
    public void generate(GitWebFrame frame, Layout layout, int width, Map<String, String> data) {
        layout.addComponent(this.createContainer(data));
    }

    public LoomBox createContainer(Map<String, String> data) {
        return new LoomBox(ContainerModule.getItem(data, "banner"), Boolean.parseBoolean(data.get("waving")));
    }

    public static class LoomBox
    extends Component {
        public static final int HEIGHT = 84;
        private final ItemStack banner;
        private final ModelPart flag;
        private final DyeColor baseColor;
        private final BannerPatternLayers resultBannerPatterns;

        public LoomBox(ItemStack banner, boolean waving) {
            super(0, 0);
            this.banner = banner;
            this.flag = Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BANNER).getChild("flag");
            this.resultBannerPatterns = (BannerPatternLayers)banner.get(DataComponents.BANNER_PATTERNS);
            this.baseColor = (DyeColor)banner.get(DataComponents.BASE_COLOR);
        }

        @Override
        protected void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
            super.render(graphics, computerScreen, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
            int i = x;
            int j = y;
            if (this.banner.isEmpty()) {
                return;
            }
            Lighting.setupForFlatItems();
            MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
            graphics.pose().pushPose();
            graphics.pose().translate((double)(i + 139), (double)(j + 90), 0.0);
            graphics.pose().scale(48.0f, -48.0f, 48.0f);
            graphics.pose().translate(0.5, 0.5, 0.5);
            float f = 0.6666667f;
            graphics.pose().scale(f, -f, -f);
            long l = System.currentTimeMillis() / 50L;
            DebugLog.log(l);
            float h = ((float)Math.floorMod(l, 100L) + partialTicks) / 100.0f;
            this.flag.yRot = (float)Math.toRadians(30.0);
            this.flag.xRot = (-0.0125f + 0.01f * Mth.cos((float)((float)Math.PI * 2 * h))) * (float)Math.PI;
            this.flag.y = -32.0f;
            BannerRenderer.renderPatterns((PoseStack)graphics.pose(), (MultiBufferSource)bufferSource, (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.flag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)this.baseColor, (BannerPatternLayers)this.resultBannerPatterns);
            graphics.pose().popPose();
            bufferSource.endBatch();
        }
    }
}

