/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.system;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.ApplicationManager;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.ScrollableLayout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.Image;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.api.app.component.Spinner;
import dev.ultreon.devices.api.utils.OnlineRequest;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.object.TrayItem;
import dev.ultreon.devices.programs.system.SystemApp;
import dev.ultreon.devices.programs.system.component.AppGrid;
import dev.ultreon.devices.programs.system.layout.LayoutAppPage;
import dev.ultreon.devices.programs.system.layout.LayoutSearchApps;
import dev.ultreon.devices.programs.system.object.AppEntry;
import dev.ultreon.devices.programs.system.object.RemoteEntry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppStore
extends SystemApp {
    public static final String CERTIFICATES_BASE_URL = "https://raw.githubusercontent.com/Ultreon/device-mod-certificates/master";
    public static final int LAYOUT_WIDTH = 250;
    public static final int LAYOUT_HEIGHT = 150;
    public List<AppEntry> certifiedApps = new ArrayList<AppEntry>();
    public List<AppEntry> localAppList = new ArrayList<AppEntry>();
    private Layout layoutMain;
    private AppInfo queuedApp;

    @Override
    public void init(@Nullable CompoundTag intent) {
        this.layoutMain = new Layout(250, 150);
        int q = ApplicationManager.getAvailableApplications().size();
        int rows = (int)Math.round(Math.ceil((double)q / 3.0));
        ScrollableLayout homePageLayout = AppStore.getHomePageLayout(rows);
        Image imageBanner = new Image(0, 0, 250, 60);
        imageBanner.setImage(ResourceLocation.fromNamespaceAndPath((String)"devices", (String)"textures/gui/app_market_background.png"));
        imageBanner.setDrawFull(true);
        homePageLayout.addComponent(imageBanner);
        Button btnSearch = new Button(5, 5, Icons.SEARCH);
        btnSearch.setToolTip("Search", "Find a specific application");
        btnSearch.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.setCurrentLayout(new LayoutSearchApps(this, this.getCurrentLayout()));
            }
        });
        homePageLayout.addComponent(btnSearch);
        Button btnManageApps = new Button(23, 5, Icons.HAMMER);
        btnManageApps.setToolTip("Manage Apps", "Manage your installed applications");
        homePageLayout.addComponent(btnManageApps);
        Image image = new Image(5, 33, 20, 20, Icons.SHOP);
        homePageLayout.addComponent(image);
        Label labelBanner = new Label("App Market", 32, 35);
        labelBanner.setScale(2.0);
        homePageLayout.addComponent(labelBanner);
        Label labelCertified = new Label(String.valueOf(ChatFormatting.WHITE) + ChatFormatting.BOLD.toString() + "Certified Apps", 10, 66);
        homePageLayout.addComponent(labelCertified);
        Label labelCertifiedDesc = new Label(String.valueOf(ChatFormatting.GRAY) + "Verified by Ultreon Studios", 240, 66);
        labelCertifiedDesc.setAlignment(1);
        labelCertifiedDesc.setScale(1.0);
        labelCertifiedDesc.setShadow(false);
        homePageLayout.addComponent(labelCertifiedDesc);
        Spinner spinner = new Spinner(119, 120);
        homePageLayout.addComponent(spinner);
        OnlineRequest.getInstance().make("https://raw.githubusercontent.com/Ultreon/device-mod-certificates/master/certified_apps.json", (success, response) -> {
            this.certifiedApps.clear();
            spinner.setVisible(false);
            if (success) {
                Minecraft.getInstance().doRunTask(() -> {
                    AppGrid grid = new AppGrid(0, 81, 3, 1, this);
                    this.certifiedApps.addAll(this.parseJson(new String(response)));
                    this.shuffleAndShrink(this.certifiedApps, 3).forEach(grid::addEntry);
                    homePageLayout.addComponent(grid);
                    grid.reloadIcons();
                });
            } else {
                Dialog.Message dialog = new Dialog.Message("Failed to load certified apps");
                dialog.setTitle("Error");
                this.openDialog(dialog);
            }
        });
        Label labelOther = new Label(String.valueOf(ChatFormatting.WHITE) + ChatFormatting.BOLD.toString() + "Other Apps", 10, 178);
        homePageLayout.addComponent(labelOther);
        Label labelOtherDesc = new Label(String.valueOf(ChatFormatting.GRAY) + "Community Created", 240, 178);
        labelOtherDesc.setAlignment(1);
        labelOtherDesc.setScale(1.0);
        labelOtherDesc.setShadow(false);
        homePageLayout.addComponent(labelOtherDesc);
        AppGrid other = new AppGrid(0, 192, 3, rows, this);
        this.shuffleAndShrink(ApplicationManager.getAvailableApplications(), q).forEach(a -> this.localAppList.add(other.addEntry((AppInfo)a)));
        homePageLayout.addComponent(other);
        this.layoutMain.addComponent(homePageLayout);
        this.setCurrentLayout(this.layoutMain);
    }

    @NotNull
    private static ScrollableLayout getHomePageLayout(int rows) {
        ScrollableLayout homePageLayout = new ScrollableLayout(0, 0, 250, 208 + 80 * rows, 150);
        homePageLayout.setScrollSpeed(10);
        homePageLayout.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            Color color = new Color(ComputerScreen.getSystem().getSettings().getColorScheme().getBackgroundColor(), true);
            int offset = 60;
            graphics.fill(x, y + offset, x + 250, y + offset + 1, color.brighter().getRGB());
            graphics.fill(x, y + offset + 1, x + 250, y + offset + 19, color.getRGB());
            graphics.fill(x, y + offset + 19, x + 250, y + offset + 20, color.darker().getRGB());
            offset = 172;
            graphics.fill(x, y + offset, x + 250, y + offset + 1, color.brighter().getRGB());
            graphics.fill(x, y + offset + 1, x + 250, y + offset + 19, color.getRGB());
            graphics.fill(x, y + offset + 19, x + 250, y + offset + 20, color.darker().getRGB());
        });
        return homePageLayout;
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.queuedApp != null) {
            for (AppEntry appEntry : this.localAppList) {
                if (!appEntry.id().equals(this.queuedApp.getId().toString())) continue;
                this.openApplication(appEntry);
                this.queuedApp = null;
                break;
            }
        }
    }

    @Override
    public void load(CompoundTag tag) {
    }

    @Override
    public void save(CompoundTag tag) {
    }

    public void queueOpen(AppInfo info) {
        this.queuedApp = info;
    }

    public List<RemoteEntry> parseJson(String json) {
        ArrayList<RemoteEntry> entries = new ArrayList<RemoteEntry>();
        JsonArray array = JsonParser.parseString((String)json).getAsJsonArray();
        Gson gson = new Gson();
        array.forEach(element -> entries.add((RemoteEntry)gson.fromJson(element, new TypeToken<RemoteEntry>(this){}.getType())));
        return entries;
    }

    public void openApplication(AppEntry entry) {
        LayoutAppPage layout = new LayoutAppPage(this.getLaptop(), entry, this);
        this.setCurrentLayout(layout);
        Button btnPrevious = new Button(2, 2, Icons.ARROW_LEFT);
        btnPrevious.setClickListener((mouseX1, mouseY1, mouseButton1) -> this.setCurrentLayout(this.layoutMain));
        layout.addComponent(btnPrevious);
    }

    private <T> List<T> shuffleAndShrink(List<T> list, int newSize) {
        Collections.shuffle(list);
        return list.subList(0, Math.min(list.size(), newSize));
    }

    public static class StoreTrayItem
    extends TrayItem {
        public StoreTrayItem() {
            super(Icons.SHOP, UltreonDevices.res("app_store"));
        }

        @Override
        public void handleClick(int mouseX, int mouseY, int mouseButton) {
            AppInfo info = ApplicationManager.getApplication(UltreonDevices.res("app_store"));
            if (info != null) {
                ComputerScreen.getSystem().launchApp(info);
            }
        }
    }
}

