/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.system.component;

import dev.ultreon.devices.api.ApplicationManager;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Image;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.programs.system.AppStore;
import dev.ultreon.devices.programs.system.object.AppEntry;
import dev.ultreon.devices.programs.system.object.LocalEntry;
import dev.ultreon.devices.programs.system.object.RemoteEntry;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class AppGrid
extends Component {
    private final int padding = 5;
    private final int horizontalItems;
    private final int verticalItems;
    private final List<AppEntry> entries = new ArrayList<AppEntry>();
    private final AppStore store;
    private final int itemWidth;
    private final int itemHeight;
    private long lastClick = 0L;
    private int clickedIndex;
    private Layout container;

    public AppGrid(int left, int top, int horizontalItems, int verticalItems, AppStore store) {
        super(left, top);
        this.horizontalItems = horizontalItems;
        this.verticalItems = verticalItems;
        this.store = store;
        this.itemWidth = (240 - 5 * (horizontalItems - 1)) / horizontalItems;
        this.itemHeight = 80;
    }

    @Override
    protected void init(Layout layout) {
        this.container = new Layout(0, 0, 250, this.horizontalItems * this.itemHeight + (this.horizontalItems + 1) * 5);
        int size = Math.min(this.entries.size(), this.verticalItems * this.horizontalItems);
        for (int i = 0; i < size; ++i) {
            AppEntry entry = this.entries.get(i);
            int itemX = this.left + i % this.horizontalItems * (this.itemWidth + 5) + 5;
            int itemY = this.top + i / this.horizontalItems * (this.itemHeight + 5) + 5;
            this.container.addComponent(this.generateAppTile(entry, itemX, itemY));
        }
        layout.addComponent(this.container);
    }

    @Override
    protected void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        int size = Math.min(this.entries.size(), this.verticalItems * this.horizontalItems);
        for (int i = 0; i < size; ++i) {
            int itemX = x + i % this.horizontalItems * (this.itemWidth + 5) + 5;
            int itemY = y + i / this.horizontalItems * (this.itemHeight + 5) + 5;
            if (!GuiHelper.isMouseWithin(mouseX, mouseY, itemX, itemY, this.itemWidth, this.itemHeight)) continue;
            graphics.fill(itemX, itemY, itemX + this.itemWidth, itemY + this.itemHeight, Color.GRAY.getRGB());
            graphics.fill(itemX + 1, itemY + 1, itemX + this.itemWidth - 1, itemY + this.itemHeight - 1, ComputerScreen.getSystem().getSettings().getColorScheme().getItemBackgroundColor());
        }
    }

    @Override
    protected void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        int size = Math.min(this.entries.size(), this.verticalItems * this.horizontalItems);
        for (int i = 0; i < size; ++i) {
            int itemX = this.xPosition + i % this.horizontalItems * (this.itemWidth + 5) + 5;
            int itemY = this.yPosition + i / this.horizontalItems * (this.itemHeight + 5) + 5;
            if (!GuiHelper.isMouseWithin(mouseX, mouseY, itemX, itemY, this.itemWidth, this.itemHeight)) continue;
            if (System.currentTimeMillis() - this.lastClick <= 200L && this.clickedIndex == i) {
                this.lastClick = 0L;
                this.store.openApplication(this.entries.get(i));
                continue;
            }
            this.lastClick = System.currentTimeMillis();
            this.clickedIndex = i;
        }
    }

    public AppEntry addEntry(AppInfo info) {
        LocalEntry a = new LocalEntry(info);
        this.entries.add(a);
        return a;
    }

    public AppEntry addEntry(AppEntry entry) {
        AppEntry a = this.adjustEntry(entry);
        this.entries.add(a);
        return a;
    }

    private AppEntry adjustEntry(AppEntry entry) {
        AppInfo info = ApplicationManager.getApplication(ResourceLocation.tryParse((String)entry.id()));
        if (info != null) {
            return new LocalEntry(info);
        }
        return entry;
    }

    private Layout generateAppTile(AppEntry entry, int left, int top) {
        Layout layout = new Layout(left, top, this.itemWidth, this.itemHeight);
        int iconOffset = (this.itemWidth - 42) / 2;
        if (entry instanceof LocalEntry) {
            LocalEntry localEntry = (LocalEntry)entry;
            Image.AppImage appImage = new Image.AppImage(iconOffset, 5, 42, 42, localEntry.info());
            layout.addComponent(appImage);
        } else if (entry instanceof RemoteEntry) {
            RemoteEntry remoteEntry = (RemoteEntry)entry;
            ResourceLocation resource = ResourceLocation.parse((String)remoteEntry.id);
            Image image = new Image(iconOffset, 5, 42, 42, "https://raw.githubusercontent.com/Ultreon/device-mod-certificates/master/assets/" + resource.getNamespace() + "/" + resource.getPath() + "/icon.png");
            layout.addComponent(image);
        }
        String clippedName = RenderUtil.clipStringToWidth(entry.name(), this.itemWidth - 10);
        Label labelName = new Label(clippedName, this.itemWidth / 2, 50);
        labelName.setAlignment(2);
        layout.addComponent(labelName);
        String clippedAuthor = RenderUtil.clipStringToWidth(entry.authors() != null ? String.join((CharSequence)", ", entry.authors()) : entry.author(), this.itemWidth - 10);
        Label labelAuthor = new Label(clippedAuthor, this.itemWidth / 2, 62);
        labelAuthor.setAlignment(2);
        labelAuthor.setShadow(false);
        layout.addComponent(labelAuthor);
        if (this.store.certifiedApps.contains(entry)) {
            Image certifiedIcon = new Image(15, 38, Icons.VERIFIED);
            layout.addComponent(certifiedIcon);
        }
        if (entry instanceof LocalEntry) {
            AppInfo info = ((LocalEntry)entry).info();
            if (ComputerScreen.getSystem().getInstalledApplications().contains(info)) {
                Image installedIcon = new Image(this.itemWidth - 10 - 15, 38, Icons.CHECK);
                layout.addComponent(installedIcon);
            }
        }
        return layout;
    }

    public void reloadIcons() {
        if (this.container != null) {
            this.reloadIcons(this.container);
        }
    }

    private void reloadIcons(Layout layout) {
        layout.components.forEach(component -> {
            if (component instanceof Layout) {
                this.reloadIcons((Layout)component);
            } else if (component instanceof Image) {
                ((Image)component).reload();
            }
        });
    }
}

