/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.system.component;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.io.Drive;
import dev.ultreon.devices.api.io.FSResponse;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.core.DataPath;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.io.action.FileAction;
import dev.ultreon.devices.programs.system.component.FSEntryType;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Unit;
import org.jetbrains.annotations.NotNull;

public final class FileInfo {
    public static final Comparator<FileInfo> SORT_BY_NAME = Comparator.comparing(a -> a.path.getFileName().toString());
    public static final Comparator<FileInfo> SORT_BY_TYPE = Comparator.comparing(a -> a.type);
    private Path path;
    private final DataPath dataPath;
    private final FSEntryType type;
    private final boolean protectedFile;
    private Drive drive;
    private boolean invalid;
    private long size;
    private long lastModified;
    private long lastAccessed;
    private long creationTime;

    public FileInfo(Drive drive, Path path, FSEntryType type, long size, boolean protectedFile) {
        this.path = path;
        this.type = type;
        this.size = size;
        this.dataPath = new DataPath(drive, path);
        this.protectedFile = protectedFile;
    }

    public static FileInfo fromTag(CompoundTag compoundTag) {
        if (!compoundTag.contains("drive")) {
            throw new IllegalArgumentException("Missing drive");
        }
        return new FileInfo(new Drive(compoundTag.getCompound("drive")), Path.of(compoundTag.getString("path")), compoundTag.getBoolean("folder") ? FSEntryType.FOLDER : FSEntryType.FILE, compoundTag.getLong("size"), compoundTag.getBoolean("protected"));
    }

    public CompoundTag toTag() {
        CompoundTag compoundTag = new CompoundTag();
        CompoundTag driveTag = new CompoundTag();
        if (this.drive == null) {
            driveTag.putString("name", "Unknown");
            driveTag.putUUID("uuid", this.dataPath.drive());
            driveTag.putString("type", Drive.Type.UNKNOWN.toString());
        } else {
            driveTag.putString("name", this.drive.getName());
            driveTag.putUUID("uuid", this.drive.getUUID());
            driveTag.putString("type", this.drive.getType().toString());
        }
        compoundTag.put("drive", (Tag)driveTag);
        compoundTag.putString("path", this.path.toString());
        compoundTag.putString("type", this.type.toString());
        compoundTag.putLong("size", this.size);
        compoundTag.putBoolean("protected", this.protectedFile);
        return compoundTag;
    }

    public boolean isFolder() {
        return this.type == FSEntryType.FOLDER;
    }

    public boolean isFile() {
        return this.type == FSEntryType.FILE;
    }

    public String getOpeningApp() {
        UltreonDevices.LOGGER.warn("getOpeningApp is not implemented");
        return null;
    }

    public boolean isExecutable() {
        return this.dataPath.path().endsWith(".apx");
    }

    @NotNull
    public String getName() {
        return this.path.getFileName().toString();
    }

    public boolean isProtected() {
        return this.protectedFile;
    }

    public void delete(Consumer<FSResponse<Unit>> callback) {
        FileSystem.request(this.dataPath.drive(), FileAction.Factory.makeDelete(this.path), callback);
    }

    public void createFile(String name, boolean override, Consumer<FSResponse<FileInfo>> callback) {
        FileSystem.request(this.dataPath.drive(), FileAction.Factory.makeNewFile(this.path, name, override), callback);
    }

    public void loadExtraInfo(Callback<Unit> callback) {
        FileSystem.request(this.dataPath.drive(), FileAction.Factory.makeExtraInfo(this.path), response -> {
            if (response.success()) {
                CompoundTag data = (CompoundTag)response.data();
                this.lastModified = data.getLong("lastModified");
                this.lastAccessed = data.getLong("lastAccessed");
                this.creationTime = data.getLong("creationTime");
            }
            if (callback != null) {
                callback.execute(Unit.INSTANCE, response.success());
            }
        });
    }

    public DataPath getDataPath() {
        return this.dataPath;
    }

    public Path getPath() {
        return this.path;
    }

    public FSEntryType getType() {
        return this.type;
    }

    public boolean protectedFile() {
        return this.protectedFile;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FileInfo that = (FileInfo)obj;
        return Objects.equals(this.path, that.path) && Objects.equals((Object)this.type, (Object)that.type) && this.protectedFile == that.protectedFile;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.type, this.protectedFile});
    }

    public String toString() {
        return "FileInfo[path=" + String.valueOf(this.path) + ", type=" + String.valueOf((Object)this.type) + ", protectedFile=" + this.protectedFile + "]";
    }

    public Drive getDrive() {
        return this.drive;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void info(Consumer<FSResponse<FileInfo>> fileInfoCallback) {
        this.drive.info(this.path, fileInfoCallback);
    }

    public void read(Consumer<FSResponse<byte[]>> callback) {
        FileSystem.request(this.dataPath.drive(), FileAction.Factory.makeRead(this.path), callback);
    }

    public void write(byte[] data, Consumer<FSResponse<FileInfo>> callback) {
        FileSystem.request(this.dataPath.drive(), FileAction.Factory.makeWrite(this.path, -1L, data), callback);
    }

    public void rename(String name, Consumer<FSResponse<Unit>> callback) {
        FileSystem.request(this.dataPath.drive(), FileAction.Factory.makeRename(this.path, name), response -> {
            if (response.success()) {
                this.path = this.path.resolveSibling(name);
            }
            if (callback != null) {
                callback.accept((FSResponse<Unit>)response);
            }
        });
    }

    public void moveTo(Path path, boolean override, Consumer<FSResponse<Unit>> callback) {
        FileSystem.request(this.dataPath.drive(), FileAction.Factory.makeMove(path, this.path, override), response -> {
            if (response.success()) {
                this.path = path;
            }
            callback.accept((FSResponse<Unit>)response);
        });
    }

    public void createDirectory(String name, Consumer<FSResponse<FileInfo>> callback) {
        FileSystem.request(this.dataPath.drive(), FileAction.Factory.makeNewFolder(this.path, name, false), callback);
    }

    public void copyTo(Path currentFolder, boolean override, Consumer<FSResponse<FileInfo>> callback) {
        FileSystem.request(this.dataPath.drive(), FileAction.Factory.makeCopy(currentFolder, this.path, override), callback);
    }

    public void copyTo(Drive drive, Path currentFolder, boolean override, Consumer<FSResponse<FileInfo>> callback) {
        FileSystem.request(this.dataPath.drive(), FileAction.Factory.makeRead(this.path), response -> FileSystem.request(drive.getUUID(), FileAction.Factory.makeWrite(currentFolder, -1L, (byte[])response.data()), callback));
    }

    public void list(Consumer<FSResponse<List<FileInfo>>> callback) {
        FileSystem.request(this.dataPath.drive(), FileAction.Factory.makeList(this.path), callback);
    }

    public void child(String name, Consumer<FSResponse<FileInfo>> callback) {
        this.drive.info(this.path.resolve(name), callback);
    }

    public FileInfo withExtension(String name) {
        FileInfo fileInfo = new FileInfo(this.drive, this.path.toString().endsWith(name) ? this.path : this.path.resolveSibling(this.getName() + "." + name), this.type, this.size, this.protectedFile);
        fileInfo.size = this.size;
        fileInfo.lastAccessed = this.lastAccessed;
        fileInfo.lastModified = this.lastModified;
        fileInfo.creationTime = this.creationTime;
        return fileInfo;
    }

    public long getSize() {
        return this.size;
    }
}

