/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.system.component;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.ComboBox;
import dev.ultreon.devices.api.app.component.Slider;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.util.GLHelper;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class Palette
extends Component {
    private final ComboBox.Custom<Integer> colorPicker;
    private Color currentColor = Color.RED;
    private Slider colorSlider;

    public Palette(int left, int top, ComboBox.Custom<Integer> colorPicker) {
        super(left, top);
        this.colorPicker = colorPicker;
    }

    @Override
    protected void init(Layout layout) {
        this.colorSlider = new Slider(5, 58, 52);
        this.colorSlider.setSlideListener(percentage -> {
            if ((double)percentage >= 0.8333333333333333) {
                this.currentColor = new Color(1.0f, 1.0f - (percentage - 0.8333334f) * 6.0f, 0.0f);
            } else if ((double)percentage >= 0.6666666666666666) {
                this.currentColor = new Color((percentage - 0.6666667f) * 6.0f, 1.0f, 0.0f);
            } else if ((double)percentage >= 0.5) {
                this.currentColor = new Color(0.0f, 1.0f, 1.0f - (percentage - 0.5f) * 6.0f);
            } else if ((double)percentage >= 0.3333333333333333) {
                this.currentColor = new Color(0.0f, (percentage - 0.33333334f) * 6.0f, 1.0f);
            } else if ((double)percentage >= 0.16666666666666666) {
                this.currentColor = new Color(1.0f - (percentage - 0.16666667f) * 6.0f, 0.0f, 1.0f);
            } else if ((double)percentage >= 0.0) {
                this.currentColor = new Color(1.0f, 0.0f, percentage * 6.0f);
            }
        });
        layout.addComponent(this.colorSlider);
    }

    @Override
    protected void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        graphics.fill(x, y, x + 52, y + 52, Color.DARK_GRAY.getRGB());
        Lighting.setupForFlatItems();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.disableBlend();
        Lighting.setupFor3DItems();
    }

    @Override
    protected void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition + 1, this.yPosition + 1, this.xPosition + 51, this.yPosition + 51)) {
            this.colorPicker.setValue(GLHelper.getPixel(mouseX, mouseY).getRGB());
        }
    }
}

