/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.system.component;

import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Image;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.programs.system.object.ImageEntry;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;

public class SlideShow
extends Component {
    private static final Color OVERLAY = new Color(0.0f, 0.0f, 0.0f, 0.15f);
    private static final Color OVERLAY_HOVER = new Color(0.35f, 0.35f, 0.35f, 0.15f);
    private final int width;
    private final int height;
    private final NonNullList<ImageEntry> IMAGES = NonNullList.create();
    private final Image image;
    private int currentImage = -1;

    public SlideShow(int left, int top, int width, int height) {
        super(left, top);
        this.width = width;
        this.height = height;
        this.image = new Image(left, top, width, height);
        this.image.setBorderVisible(true);
    }

    @Override
    protected void init(Layout layout) {
        this.image.setDrawFull(true);
        this.image.init(layout);
    }

    @Override
    protected void handleLoad() {
        this.image.handleLoad();
    }

    @Override
    protected void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (!this.visible) {
            return;
        }
        this.image.render(graphics, computerScreen, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
        if (this.currentImage > 0) {
            if (GuiHelper.isMouseWithin(mouseX, mouseY, x, y, 15, this.height)) {
                graphics.fill(x, y, x + 15, y + this.height, OVERLAY_HOVER.getRGB());
            } else {
                graphics.fill(x, y, x + 15, y + this.height, OVERLAY.getRGB());
            }
            Icons.CHEVRON_LEFT.draw(graphics, mc, x + 2, y + (this.height - 10) / 2);
        }
        if (this.currentImage < this.IMAGES.size() - 1) {
            if (GuiHelper.isMouseWithin(mouseX, mouseY, x + this.width - 15, y, 15, this.height)) {
                graphics.fill(x + this.width - 15, y, x + this.width, y + this.height, OVERLAY_HOVER.getRGB());
            } else {
                graphics.fill(x + this.width - 15, y, x + this.width, y + this.height, OVERLAY.getRGB());
            }
            Icons.CHEVRON_RIGHT.draw(graphics, mc, x + 3 + this.width - 15, y + (this.height - 10) / 2);
        }
    }

    @Override
    protected void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled || mouseButton != 0) {
            return;
        }
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition, this.yPosition, 15, this.height) && this.currentImage > 0) {
            this.setImage(this.currentImage - 1);
        }
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition + this.width - 15, this.yPosition, 15, this.height) && this.currentImage < this.IMAGES.size() - 1) {
            this.setImage(this.currentImage + 1);
        }
    }

    public void addImage(ResourceLocation resource) {
        this.IMAGES.add((Object)new ImageEntry(resource));
        if (this.currentImage == -1) {
            this.setImage(0);
        }
    }

    public void addImage(String url) {
        this.IMAGES.add((Object)new ImageEntry(url));
        if (this.currentImage == -1) {
            this.setImage(0);
        }
    }

    public void setImage(int index) {
        if (this.IMAGES.isEmpty() && index < 0 && index >= this.IMAGES.size()) {
            return;
        }
        this.currentImage = index;
        ImageEntry entry = (ImageEntry)this.IMAGES.get(index);
        switch (entry.getType()) {
            case LOCAL: {
                this.image.setImage(entry.getResource());
                break;
            }
            case REMOTE: {
                this.image.setImage(entry.getUrl());
            }
        }
    }
}

