/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.system.layout;

import com.google.common.collect.Lists;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.ScrollableLayout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.Image;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.Permission;
import dev.ultreon.devices.core.PermissionRequest;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.programs.gitweb.component.GitWebFrame;
import dev.ultreon.devices.programs.system.AppStore;
import dev.ultreon.devices.programs.system.component.SlideShow;
import dev.ultreon.devices.programs.system.object.AppEntry;
import dev.ultreon.devices.programs.system.object.LocalEntry;
import dev.ultreon.devices.programs.system.object.RemoteEntry;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import java.nio.file.AccessDeniedException;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class LayoutAppPage
extends Layout {
    private final ComputerScreen computerScreen;
    private final AppEntry entry;
    private final AppStore store;
    private Component imageIcon;
    private boolean installed;

    public LayoutAppPage(ComputerScreen computerScreen, AppEntry entry, AppStore store) {
        super(250, 150);
        this.computerScreen = computerScreen;
        this.entry = entry;
        this.store = store;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init() {
        SlideShow slideShow;
        block20: {
            ResourceLocation resource;
            block19: {
                if (this.entry instanceof LocalEntry) {
                    this.installed = ComputerScreen.getSystem().getInstalledApplications().contains(((LocalEntry)this.entry).info());
                }
                this.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
                    Color color = new Color(ComputerScreen.getSystem().getSettings().getColorScheme().getBackgroundColor(), true);
                    graphics.fill(x, y + 40, x + width, y + 41, color.brighter().getRGB());
                    graphics.fill(x, y + 41, x + width, y + 60, color.getRGB());
                    graphics.fill(x, y + 60, x + width, y + 61, color.darker().getRGB());
                });
                resource = ResourceLocation.tryParse((String)this.entry.id());
                if (resource == null) {
                    this.store.getWindow().close();
                    this.computerScreen.openDialog(new Dialog.Message("Invalid app id: " + this.entry.id()));
                    return;
                }
                Image imageBanner = new Image(0, 0, 250, 40);
                imageBanner.setDrawFull(true);
                imageBanner.setBorderVisible(true);
                imageBanner.setBorderThickness(0);
                if (this.entry instanceof LocalEntry) {
                    imageBanner.setImage(ResourceLocation.fromNamespaceAndPath((String)resource.getNamespace(), (String)("textures/app/banner/" + resource.getPath() + ".png")));
                } else if (this.entry instanceof RemoteEntry) {
                    imageBanner.setImage("https://raw.githubusercontent.com/Ultreon/device-mod-certificates/master/assets/" + resource.getNamespace() + "/" + resource.getPath() + "/banner.png");
                }
                this.addComponent(imageBanner);
                AppEntry appEntry = this.entry;
                if (appEntry instanceof LocalEntry) {
                    LocalEntry localEntry = (LocalEntry)appEntry;
                    try {
                        AppInfo appInfo;
                        AppInfo info = appInfo = localEntry.info();
                        this.imageIcon = new Image.AppImage(5, 26, 28, 28, info);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                } else if (this.entry instanceof RemoteEntry) {
                    this.imageIcon = new Image(5, 26, 28, 28, "https://raw.githubusercontent.com/Ultreon/device-mod-certificates/master/assets/" + resource.getNamespace() + "/" + resource.getPath() + "/icon.png");
                }
                this.addComponent(this.imageIcon);
                if (this.store.certifiedApps.contains(this.entry)) {
                    int width2 = ComputerScreen.getFont().width(this.entry.name()) * 2;
                    Image certifiedIcon = new Image(38 + width2 + 3, 29, 20, 20, Icons.VERIFIED);
                    this.addComponent(certifiedIcon);
                }
                Label labelTitle = new Label(this.entry.name(), 38, 32);
                labelTitle.setScale(2.0);
                this.addComponent(labelTitle);
                String version = this.entry instanceof LocalEntry ? "v" + this.entry.version() + " - " + this.entry.author() : this.entry.author();
                Label labelVersion = new Label(version, 38, 50);
                this.addComponent(labelVersion);
                String description = GitWebFrame.parseFormatting(this.entry.description());
                ScrollableLayout descriptionLayout = ScrollableLayout.create(130, 67, 115, 78, description);
                this.addComponent(descriptionLayout);
                slideShow = new SlideShow(5, 67, 120, 78);
                if (!(this.entry instanceof LocalEntry)) break block19;
                if (this.entry.screenshots() != null) {
                    for (String image : this.entry.screenshots()) {
                        if (image == null) {
                            slideShow.addImage(ResourceLocation.fromNamespaceAndPath((String)"devices", (String)"invalid.png"));
                            continue;
                        }
                        if (image.startsWith("http://") || image.startsWith("https://")) {
                            slideShow.addImage(image);
                            continue;
                        }
                        ResourceLocation resource1 = ResourceLocation.tryParse((String)image);
                        if (resource1 == null) {
                            slideShow.addImage(ResourceLocation.fromNamespaceAndPath((String)"devices", (String)"invalid.png"));
                        }
                        slideShow.addImage(resource1);
                    }
                }
                break block20;
            }
            String[] stringArray = this.entry;
            if (stringArray instanceof RemoteEntry) {
                RemoteEntry remoteEntry = (RemoteEntry)stringArray;
                String screenshotUrl = "https://raw.githubusercontent.com/Ultreon/device-mod-certificates/master/assets/" + resource.getNamespace() + "/" + resource.getPath() + "/screenshots/screenshot_%d.png";
                for (int i = 0; i < remoteEntry.screenshots; ++i) {
                    slideShow.addImage(String.format(screenshotUrl, i));
                }
            }
        }
        this.addComponent(slideShow);
        if (!(this.entry instanceof LocalEntry)) {
            if (!(this.entry instanceof RemoteEntry)) return;
            Button btnDownload = new Button(20, 2, "Download", Icons.IMPORT);
            btnDownload.setSize(66, 16);
            btnDownload.setClickListener((mouseX, mouseY, mouseButton) -> this.openWebLink("https://minecraft.curseforge.com/projects/" + ((RemoteEntry)this.entry).projectId));
            this.addComponent(btnDownload);
            return;
        }
        AppInfo info = ((LocalEntry)this.entry).info();
        Button btnInstall = new Button(20, 2, this.installed ? "Delete" : "Install", this.installed ? Icons.CROSS : Icons.PLUS);
        btnInstall.setSize(55, 16);
        btnInstall.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.installed) {
                    this.computerScreen.removeApplication(info, (o, success) -> {
                        btnInstall.setText("Install");
                        btnInstall.setIcon(Icons.PLUS);
                        this.installed = false;
                    });
                } else {
                    this.computerScreen.requestPermission(new PermissionRequest("Software installation", Permission.SOFTWARE_MANAGEMENT, info), result -> {
                        if (result.granted()) {
                            try {
                                this.computerScreen.installApplication(info, (o, success) -> {
                                    DebugLog.log("Installation Succeeded: " + success);
                                    btnInstall.setText("Delete");
                                    btnInstall.setIcon(Icons.CROSS);
                                    this.installed = true;
                                });
                            }
                            catch (AccessDeniedException e) {
                                this.store.openDialog(new Dialog.Message(e.getMessage()));
                            }
                        }
                    });
                }
            }
        });
        this.addComponent(btnInstall);
        if (info.getSupport() == null) return;
        Button btnDonate = new Button(234, 44, Icons.COIN);
        btnDonate.setToolTip("Donate", "Opens a link to donate to author of the application");
        btnDonate.setSize(14, 14);
        this.addComponent(btnDonate);
    }

    @Override
    public void renderOverlay(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int mouseX, int mouseY, boolean windowActive) {
        int width;
        super.renderOverlay(graphics, computerScreen, mc, mouseX, mouseY, windowActive);
        if (this.store.certifiedApps.contains(this.entry) && GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition + 38 + (width = ComputerScreen.getFont().width(this.entry.name()) * 2) + 3, this.yPosition + 29, 20, 20)) {
            computerScreen.renderComponentTooltip(graphics, Lists.newArrayList((Object[])new net.minecraft.network.chat.Component[]{net.minecraft.network.chat.Component.literal((String)"Certified App").withStyle(ChatFormatting.GREEN)}), mouseX, mouseY);
        }
    }

    private void openWebLink(String url) {
        Util.getPlatform().openUri(url);
    }
}

