/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.util;

import com.google.common.collect.ImmutableMap;
import dev.ultreon.mods.xinexlib.registrar.Registrar;
import dev.ultreon.mods.xinexlib.registrar.RegistrySupplier;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;

public abstract class DyeableRegistration<T extends O, O>
implements Iterable<RegistrySupplier<T, O>> {
    private final Map<DyeColor, RegistrySupplier<T, O>> map = new EnumMap<DyeColor, RegistrySupplier<T, O>>(DyeColor.class);
    private final List<RegistrySupplier<T, O>> l = new ArrayList<RegistrySupplier<T, O>>();

    protected DyeableRegistration() {
        Registrar<O> registrar = this.autoInit();
        if (registrar != null) {
            DyeableRegistration.register(registrar, this);
        }
    }

    public static <T extends O, O> void register(Registrar<O> registrar, DyeableRegistration<T, O> dyeableRegistration) {
        for (DyeColor dye : DyeableRegistration.getDyes()) {
            RegistrySupplier<T, O> dg = dyeableRegistration.register(registrar, dye);
            dyeableRegistration.l.add(dg);
            dyeableRegistration.map.put(dye, dg);
        }
    }

    private static List<@NotNull DyeColor> getDyes() {
        return List.of(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK);
    }

    public abstract RegistrySupplier<T, O> register(Registrar<O> var1, DyeColor var2);

    public ImmutableMap<DyeColor, RegistrySupplier<T, O>> getMap() {
        return ImmutableMap.copyOf(this.map);
    }

    protected Registrar<O> autoInit() {
        return null;
    }

    public RegistrySupplier<T, O> of(DyeColor dyeColor) {
        return this.map.get(dyeColor);
    }

    @Override
    @NotNull
    public Iterator<RegistrySupplier<T, O>> iterator() {
        return this.l.iterator();
    }
}

