/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.util;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.programs.gitweb.component.GitWebFrame;
import java.util.Locale;
import java.util.regex.Matcher;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public record SiteRegistration(String registrant, String string, Type type, String site) {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"SITE_REGISTER");

    public SiteRegistration(String registrant, String string, String type, String site) {
        this(registrant, string, Type.of(type), site);
    }

    public static String getURL(String website) {
        Matcher matcher = GitWebFrame.PATTERN_LINK.matcher(website);
        if (!matcher.matches()) {
            UltreonDevices.LOGGER.error("No Match Found For {}!", (Object)website);
            return "https://raw.githubusercontent.com/Ultreon/gitweb-sites/main/";
        }
        String domain = matcher.group("domain");
        String extension = matcher.group("extension");
        String directory = matcher.group("directory");
        String url = "https://raw.githubusercontent.com/Ultreon/gitweb-sites/main/";
        for (SiteRegistration siteRegistration : UltreonDevices.SITE_REGISTRATIONS) {
            Matcher directoryMatcher;
            if (siteRegistration.type == Type.ALL) {
                url = siteRegistration.site;
                continue;
            }
            if (siteRegistration.type == Type.EXTENSION && siteRegistration.string.equals(extension)) {
                url = siteRegistration.site;
                continue;
            }
            if (siteRegistration.type == Type.DOMAIN && domain != null) {
                Matcher domainMatcher = GitWebFrame.PATTERN_LINK.matcher(siteRegistration.string);
                if (!domainMatcher.matches() || !domainMatcher.group("domain").equals(domain) || !domainMatcher.group("extension").equals(extension)) continue;
                url = siteRegistration.site;
                continue;
            }
            if (siteRegistration.type != Type.DIRECTORY || directory == null || !(directoryMatcher = GitWebFrame.PATTERN_LINK.matcher(siteRegistration.string)).matches() || !directoryMatcher.group("domain").equals(domain) || !directoryMatcher.group("extension").equals(extension) || !directoryMatcher.group("directory").equals(directory)) continue;
            url = siteRegistration.site;
        }
        UltreonDevices.LOGGER.info(MARKER, "Registered Sites: {}, URL: {}", (Object)UltreonDevices.SITE_REGISTRATIONS.size(), (Object)url);
        return url;
    }

    public static enum Type {
        ALL,
        EXTENSION,
        DOMAIN,
        DIRECTORY;


        public static Type of(String type) {
            if (type.equals("*")) {
                return ALL;
            }
            return Type.valueOf(type.toUpperCase(Locale.ROOT));
        }

        public static Type compare(Type a, Type b) {
            return a.ordinal() > b.ordinal() ? b : a;
        }
    }
}

