/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.util;

public class TimeUtil {
    public static String getTotalRealTime(long ticks) {
        int days = (int)(ticks / 1728000L);
        int hours = (int)Math.floor((double)ticks / 24000.0) % 24;
        int minutes = (int)Math.floor(ticks / 1200L) % 60;
        int seconds = (int)Math.floor(ticks / 20L) % 60;
        if (days > 0) {
            return String.format("%dd %dh %dm %ds", days, hours, minutes, seconds);
        }
        if (hours > 0) {
            return String.format("%dh %dm %ds", hours, minutes, seconds);
        }
        if (minutes > 0) {
            return String.format("%dm %ds", minutes, seconds);
        }
        return String.format("%ds", seconds);
    }

    public static String getTotalGameTime(long ticks) {
        int days = (int)(ticks / 24000L);
        int hours = (int)((Math.floor((double)ticks / 1000.0) + 7.0) % 24.0);
        int minutes = (int)Math.floor((double)(ticks % 1000L) / 1000.0 * 60.0);
        return String.format("%02d:%02d", hours, minutes);
    }

    public static String getGameTime(long ticks) {
        int hours = (int)((Math.floor((double)ticks / 1000.0) + 7.0) % 24.0);
        int minutes = (int)Math.floor((double)(ticks % 1000L) / 1000.0 * 60.0);
        return String.format("%02d:%02d", hours, minutes);
    }

    public static long getRealTimeToTicks(int hours, int minutes, int seconds) {
        return (long)hours * 72000L + (long)minutes * 1200L + (long)seconds * 20L;
    }
}

