/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.client.util.model_data.base;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import nordmods.uselessreptile.UselessReptile;
import nordmods.uselessreptile.client.util.model_data.base.EquipmentModelData;
import nordmods.uselessreptile.client.util.model_data.base.ModelData;

public record DragonModelData(ModelData modelData, Optional<List<EquipmentModelData>> equipmentModelDataOverrides, boolean nametagAccessible) {
    private static final Map<String, Map<String, DragonModelData>> dragonModelDataHolder = new HashMap<String, Map<String, DragonModelData>>();
    public static final Codec<DragonModelData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModelData.CODEC.fieldOf("model_data").forGetter(DragonModelData::modelData), (App)EquipmentModelData.CODEC.listOf().optionalFieldOf("equipment_model_overrides").forGetter(DragonModelData::equipmentModelDataOverrides), (App)Codec.BOOL.optionalFieldOf("nametag_accessible", (Object)true).forGetter(DragonModelData::nametagAccessible)).apply((Applicative)instance, DragonModelData::new));

    public static DragonModelData deserialize(JsonElement element) throws JsonParseException {
        JsonObject input = element.getAsJsonObject();
        DataResult result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)input);
        return (DragonModelData)result.getOrThrow();
    }

    public static void add(String dragon, String variant, DragonModelData modelData) {
        Map<String, DragonModelData> content = dragonModelDataHolder.get(dragon);
        if (content != null) {
            if (!content.containsKey(variant)) {
                content.put(variant, modelData);
            }
        } else {
            content = new HashMap<String, DragonModelData>();
            content.put(variant, modelData);
            dragonModelDataHolder.put(dragon, content);
        }
    }

    public static void debugPrint() {
        for (Map.Entry<String, Map<String, DragonModelData>> entry : dragonModelDataHolder.entrySet()) {
            for (Map.Entry<String, DragonModelData> data : entry.getValue().entrySet()) {
                UselessReptile.LOGGER.debug("{}: {}, {}", new Object[]{entry.getKey(), data.getKey(), data.getValue()});
            }
        }
    }

    public static void reset() {
        dragonModelDataHolder.clear();
    }

    public static Set<Map.Entry<String, Map<String, DragonModelData>>> getEntries() {
        return dragonModelDataHolder.entrySet();
    }

    public static Map<String, DragonModelData> getModelData(String dragon) {
        return dragonModelDataHolder.get(dragon);
    }
}

