/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.common.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3966;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7430;
import net.minecraft.class_7441;
import net.minecraft.class_7444;
import net.minecraft.class_9279;
import net.minecraft.server.MinecraftServer;
import nordmods.uselessreptile.common.entity.base.URDragonEntity;
import nordmods.uselessreptile.common.entity.base.URDragonPart;
import nordmods.uselessreptile.common.init.URItems;
import nordmods.uselessreptile.common.init.URSounds;
import nordmods.uselessreptile.common.item.component.URDragonDataStorageComponent;
import nordmods.uselessreptile.common.item.component.VortexHornCapacityComponent;
import org.jetbrains.annotations.Nullable;

public class VortexHornItem
extends class_7430 {
    private final int maxCapacity;

    public VortexHornItem(class_1792.class_1793 settings, class_6862<class_7444> instrumentTag, int maxCapacity) {
        super(settings, instrumentTag);
        this.maxCapacity = maxCapacity;
    }

    public VortexHornItem(class_1792.class_1793 settings, int maxCapacity) {
        this(settings, (class_6862<class_7444>)class_7441.field_39108, maxCapacity);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        URDragonEntity dragon;
        URDragonEntity uRDragonEntity = this.getPartParent(user);
        if (uRDragonEntity instanceof URDragonEntity) {
            dragon = uRDragonEntity;
            entity = dragon;
        }
        if (entity instanceof URDragonEntity && (dragon = (URDragonEntity)entity).method_35057() == user && !user.method_5715() && this.tryCollectDragon(stack, user, dragon, hand, true)) {
            user.method_6075();
            user.method_56078(URSounds.VORTEX_HORN_SUCK_IN);
            return class_1269.field_5812;
        }
        return super.method_7847(stack, user, entity, hand);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (user.method_5715() && this.tryMassCatchOrRelease(stack, user, world, hand)) {
            return class_1271.method_22427((Object)stack);
        }
        URDragonEntity uRDragonEntity = this.getPartParent(user);
        if (uRDragonEntity instanceof URDragonEntity) {
            URDragonEntity dragon = uRDragonEntity;
            this.method_7847(stack, user, (class_1309)dragon, hand);
            user.method_6075();
            return class_1271.method_22427((Object)stack);
        }
        class_1271 result = super.method_7836(world, user, hand);
        user.method_7357().method_7906((class_1792)this, 0);
        return result;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_1657 class_16572 = context.method_8036();
        if (class_16572 instanceof class_1657) {
            class_1657 user = class_16572;
            class_1937 world = context.method_8045();
            class_1268 hand = context.method_20287();
            if (user.method_5715() && this.tryMassCatchOrRelease(stack, user, world, hand)) {
                user.method_6075();
                return class_1269.field_5812;
            }
            class_2338 pos = context.method_8037();
            class_2680 blockState = world.method_8320(pos);
            class_2350 direction = context.method_8038();
            if (!blockState.method_26220((class_1922)world, pos).method_1110()) {
                pos = pos.method_10093(direction);
            }
            if (this.tryCreateDragon(stack, user, world, hand, pos)) {
                user.method_6075();
                user.method_56078(URSounds.VORTEX_HORN_SPIT_OUT);
                return class_1269.field_5812;
            }
        }
        return super.method_7884(context);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (stack.method_57353().method_57832(URItems.DRAGON_STORAGE_COMPONENT)) {
            URDragonDataStorageComponent dataComponent = (URDragonDataStorageComponent)stack.method_57824(URItems.DRAGON_STORAGE_COMPONENT);
            if (dataComponent != null) {
                boolean full = this.getCurrentCapacity(stack) >= this.maxCapacity;
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.uselessreptile.vortex_horn.capacity", (Object[])new Object[]{this.getCurrentCapacity(stack), this.maxCapacity}).method_27692(full ? class_124.field_1054 : class_124.field_1080));
                if (!class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)340)) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.uselessreptile.hidden").method_27692(class_124.field_1063));
                } else {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.uselessreptile.vortex_horn.contained_dragons"));
                    for (class_9279 nbtComponent : dataComponent.entityData()) {
                        String string;
                        class_2487 nbt = nbtComponent.method_57461();
                        if (nbtComponent.method_57450("CustomName")) {
                            string = nbt.method_10558("CustomName");
                            tooltip.add((class_2561)class_2561.class_2562.method_10877((String)string, (class_7225.class_7874)class_310.method_1551().field_1724.method_56673()));
                            continue;
                        }
                        string = nbt.method_10558("id");
                        Optional entityType = class_1299.method_5898((String)string);
                        tooltip.add((class_2561)entityType.map(value -> class_2561.method_43471((String)value.method_5882())).orElseGet(() -> class_2561.method_43470((String)"ERROR").method_27692(class_124.field_1061)));
                    }
                }
            }
            tooltip.add((class_2561)class_2561.method_43473());
        }
        super.method_7851(stack, context, tooltip, type);
    }

    protected boolean tryMassCatchOrRelease(class_1799 stack, class_1657 user, class_1937 world, class_1268 hand) {
        class_238 box = new class_238(user.method_24515()).method_1014(2.0);
        List dragons = world.method_8390(URDragonEntity.class, box, entity -> entity.method_35057() == user && !entity.getIsSitting());
        int leastCapacity = 0;
        if (!dragons.isEmpty()) {
            leastCapacity = ((URDragonEntity)dragons.getFirst()).vortexHornCapacity();
            for (URDragonEntity dragon2 : dragons) {
                leastCapacity = Math.min(leastCapacity, dragon2.vortexHornCapacity());
            }
        }
        if (leastCapacity <= 0 || this.getCurrentCapacity(stack) + leastCapacity > this.getMaxCapacity()) {
            URDragonDataStorageComponent dataComponent = (URDragonDataStorageComponent)stack.method_57824(URItems.DRAGON_STORAGE_COMPONENT);
            if (dataComponent != null && this.getCurrentCapacity(stack) > 0) {
                for (int i = 0; i < dataComponent.entityData().size(); ++i) {
                    this.tryCreateDragon(stack, user, world, hand, user.method_24515());
                }
                user.method_56078(URSounds.VORTEX_HORN_SPIT_OUT);
                return true;
            }
        } else {
            URDragonEntity dragon2;
            dragons.sort(Comparator.comparingDouble(dragon -> dragon.method_5858((class_1297)dragon.method_35057())));
            Iterator iterator = dragons.iterator();
            while (iterator.hasNext() && ((dragon2 = (URDragonEntity)iterator.next()).getIsSitting() || this.tryCollectDragon(stack, user, dragon2, hand, false))) {
            }
            user.method_56078(URSounds.VORTEX_HORN_SUCK_IN);
            return true;
        }
        return false;
    }

    protected boolean tryCollectDragon(class_1799 stack, class_1657 user, URDragonEntity dragon, class_1268 hand, boolean capacityWarning) {
        URDragonDataStorageComponent appliedComponent;
        int dragonCapacity = dragon.vortexHornCapacity();
        if (this.getCurrentCapacity(stack) + dragonCapacity > this.getMaxCapacity()) {
            if (capacityWarning && !user.method_37908().method_8608()) {
                user.method_7353((class_2561)class_2561.method_43471((String)"other.uselessreptile.not_enough_capacity"), true);
            }
            return false;
        }
        if (user.method_37908().method_8608()) {
            return true;
        }
        dragon.method_5848();
        dragon.method_5772();
        URDragonDataStorageComponent dataComponent = (URDragonDataStorageComponent)stack.method_57824(URItems.DRAGON_STORAGE_COMPONENT);
        if (dataComponent != null) {
            ArrayList<class_9279> dragons = new ArrayList<class_9279>(dataComponent.entityData());
            class_9279 data = URDragonDataStorageComponent.createData((class_1297)dragon);
            dragons.add(data);
            appliedComponent = new URDragonDataStorageComponent(dragons);
        } else {
            appliedComponent = URDragonDataStorageComponent.DEFAULT;
        }
        stack.method_57379(URItems.DRAGON_STORAGE_COMPONENT, (Object)appliedComponent);
        VortexHornCapacityComponent capacityComponent = new VortexHornCapacityComponent(((VortexHornCapacityComponent)stack.method_57825(URItems.VORTEX_HORN_CAPACITY_COMPONENT, (Object)VortexHornCapacityComponent.DEFAULT)).capacity() + dragonCapacity);
        stack.method_57379(URItems.VORTEX_HORN_CAPACITY_COMPONENT, (Object)capacityComponent);
        user.method_6122(hand, stack);
        this.spawnCloud((class_1297)dragon);
        dragon.method_31472();
        return true;
    }

    protected boolean tryCreateDragon(class_1799 stack, class_1657 user, class_1937 world, class_1268 hand, class_2338 pos) {
        URDragonDataStorageComponent dataComponent = (URDragonDataStorageComponent)stack.method_57824(URItems.DRAGON_STORAGE_COMPONENT);
        if (dataComponent != null) {
            ArrayList<class_9279> dragons = new ArrayList<class_9279>(dataComponent.entityData());
            if (dragons.isEmpty()) {
                return false;
            }
            class_9279 last = (class_9279)dragons.getLast();
            if (!world.method_8608()) {
                URDragonEntity urDragon;
                class_1297 dragon = URDragonDataStorageComponent.createEntity(last, world);
                if (dragon == null) {
                    return false;
                }
                dragon.method_23327((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
                if (dragon instanceof URDragonEntity) {
                    urDragon = (URDragonEntity)dragon;
                    urDragon.setHomePoint(pos);
                    urDragon.setBoundedInstrumentSound(URDragonEntity.getInstrument(stack));
                    urDragon.updateEquipment();
                    VortexHornCapacityComponent capacityComponent = new VortexHornCapacityComponent(((VortexHornCapacityComponent)stack.method_57825(URItems.VORTEX_HORN_CAPACITY_COMPONENT, (Object)VortexHornCapacityComponent.DEFAULT)).capacity() - urDragon.vortexHornCapacity());
                    stack.method_57379(URItems.VORTEX_HORN_CAPACITY_COMPONENT, (Object)capacityComponent);
                    this.spawnCloud((class_1297)urDragon);
                }
                world.method_8649(dragon);
                if (dragon instanceof URDragonEntity && (urDragon = (URDragonEntity)dragon).method_35057() != user) {
                    urDragon.method_5980((class_1309)user);
                }
            }
            dragons.removeLast();
            stack.method_57379(URItems.DRAGON_STORAGE_COMPONENT, (Object)new URDragonDataStorageComponent(dragons));
            user.method_6122(hand, stack);
            return true;
        }
        return false;
    }

    protected void spawnCloud(class_1297 dragon) {
        MinecraftServer server = dragon.method_5682();
        if (server != null) {
            double x = dragon.method_23317();
            double y = dragon.method_23318();
            double z = dragon.method_23321();
            float offsetY = dragon.method_17682() / 2.0f;
            float offsetXZ = dragon.method_17681() / 2.0f;
            class_2675 packet = new class_2675((class_2394)class_2398.field_11204, false, x, y, z, offsetXZ, offsetY, offsetXZ, 0.0f, 20);
            server.method_3760().method_14605(null, x, y + (double)offsetY, z, 128.0, dragon.method_37908().method_27983(), (class_2596)packet);
        }
    }

    protected int getCurrentCapacity(class_1799 stack) {
        VortexHornCapacityComponent dataComponent;
        if (stack.method_57353().method_57832(URItems.VORTEX_HORN_CAPACITY_COMPONENT) && (dataComponent = (VortexHornCapacityComponent)stack.method_57824(URItems.VORTEX_HORN_CAPACITY_COMPONENT)) != null) {
            return dataComponent.capacity();
        }
        return 0;
    }

    @Nullable
    protected URDragonEntity getPartParent(class_1657 user) {
        class_1297 class_12972;
        class_239 hitResult = class_1675.method_49998((class_1297)user, entity -> entity instanceof URDragonPart, (double)user.method_55755());
        if (hitResult.method_17783() == class_239.class_240.field_1331 && (class_12972 = ((class_3966)hitResult).method_17782()) instanceof URDragonPart) {
            URDragonPart part = (URDragonPart)class_12972;
            return part.owner;
        }
        return null;
    }

    protected int getMaxCapacity() {
        return this.maxCapacity;
    }
}

