/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.common.dragon_variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import nordmods.uselessreptile.common.entity.base.URDragonEntity;
import nordmods.uselessreptile.common.init.URRegistryKeys;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DragonVariant(class_2960 dragonId, String name, Optional<String> displayNameKey, class_2960 dragonModelData, class_2960 dragonEquipment, Optional<class_2960> spawnConditions, Optional<class_2960> variantAttributeModifiers) {
    public static final Codec<DragonVariant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(DragonVariant::dragonId), (App)Codec.STRING.fieldOf("name").forGetter(DragonVariant::name), (App)Codec.STRING.optionalFieldOf("display_name_key").forGetter(DragonVariant::displayNameKey), (App)class_2960.field_25139.fieldOf("dragon_model").forGetter(DragonVariant::dragonModelData), (App)class_2960.field_25139.fieldOf("equipment").forGetter(DragonVariant::dragonEquipment), (App)class_2960.field_25139.optionalFieldOf("spawn_conditions").forGetter(DragonVariant::spawnConditions), (App)class_2960.field_25139.optionalFieldOf("attribute_modifiers").forGetter(DragonVariant::variantAttributeModifiers)).apply((Applicative)instance, DragonVariant::new));
    public static final Codec<DragonVariant> CODEC_NO_SERVER_INFO = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(DragonVariant::dragonId), (App)Codec.STRING.fieldOf("name").forGetter(DragonVariant::name), (App)Codec.STRING.optionalFieldOf("display_name_key").forGetter(DragonVariant::displayNameKey), (App)class_2960.field_25139.fieldOf("dragon_model").forGetter(DragonVariant::dragonModelData), (App)class_2960.field_25139.fieldOf("equipment").forGetter(DragonVariant::dragonEquipment)).apply((Applicative)instance, (id, variant, displayNameKey, dragonModelData, dragonEquipment) -> new DragonVariant((class_2960)id, (String)variant, (Optional<String>)displayNameKey, (class_2960)dragonModelData, (class_2960)dragonEquipment, Optional.empty(), Optional.empty())));

    @NotNull
    public static DragonVariant getDefaultVariant(class_2960 dragonId, class_1937 world) {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10582("id", dragonId.toString());
        URDragonEntity dragon = (URDragonEntity)class_1299.method_5892((class_2487)nbtCompound, (class_1937)world, (class_3730)class_3730.field_16461).get();
        dragon.method_31472();
        return dragon.method_37908().method_30349().method_30530(URRegistryKeys.DRAGON_VARIANT).method_10220().filter(dragonVariant -> dragonVariant.dragonId().equals((Object)dragon.getDragonId()) && dragonVariant.name().equals(dragon.getDefaultVariant())).findFirst().orElseThrow();
    }

    @Nullable
    public static DragonVariant getByVariant(class_2960 dragonId, String variant, class_1937 world) {
        class_2378 registry = world.method_30349().method_30530(URRegistryKeys.DRAGON_VARIANT);
        return registry.method_10220().filter(dragonVariant -> dragonVariant.dragonId().equals((Object)dragonId) && dragonVariant.name().equals(variant)).findFirst().orElse(null);
    }

    @Nullable
    public static DragonVariant getByCustomName(class_2960 dragonId, String name, class_1937 world) {
        class_2378 registry = world.method_30349().method_30530(URRegistryKeys.DRAGON_VARIANT_CUSTOM_NAME);
        return registry.method_10220().filter(dragonVariant -> dragonVariant.dragonId().equals((Object)dragonId) && dragonVariant.name().equals(name)).findFirst().orElse(null);
    }

    public static DragonVariant getDragonVariant(class_2960 dragonId, String name, String variant, class_1937 world) {
        DragonVariant dragonVariant = null;
        if (name != null) {
            dragonVariant = DragonVariant.getByCustomName(dragonId, name, world);
        }
        if (dragonVariant != null) {
            return dragonVariant;
        }
        dragonVariant = DragonVariant.getByVariant(dragonId, variant, world);
        if (dragonVariant != null) {
            return dragonVariant;
        }
        return DragonVariant.getDefaultVariant(dragonId, world);
    }
}

