/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.common.init;

import com.mojang.serialization.Codec;
import java.util.List;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.minecraft.class_1322;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import nordmods.uselessreptile.UselessReptile;
import nordmods.uselessreptile.common.dragon_variant.DragonVariant;
import nordmods.uselessreptile.common.dragon_variant.model.DragonEquipment;
import nordmods.uselessreptile.common.dragon_variant.model.DragonModel;
import nordmods.uselessreptile.common.dragon_variant.spawn.DragonSpawnConditions;

public class URRegistryKeys {
    public static final class_5321<class_2378<DragonVariant>> DRAGON_VARIANT = class_5321.method_29180((class_2960)UselessReptile.id("variant"));
    public static final class_5321<class_2378<DragonVariant>> DRAGON_VARIANT_CUSTOM_NAME = class_5321.method_29180((class_2960)UselessReptile.id("custom_name"));
    public static final class_5321<class_2378<DragonModel>> DRAGON_MODEL = class_5321.method_29180((class_2960)UselessReptile.id("dragon_model"));
    public static final class_5321<class_2378<DragonEquipment>> DRAGON_EQUIPMENT = class_5321.method_29180((class_2960)UselessReptile.id("equipment"));
    public static final class_5321<class_2378<DragonEquipment>> DRAGON_EQUIPMENT_INJECT = class_5321.method_29180((class_2960)UselessReptile.id("equipment_inject"));
    public static final class_5321<class_2378<List<DragonSpawnConditions>>> DRAGON_SPAWN_CONDITIONS = class_5321.method_29180((class_2960)UselessReptile.id("spawn_conditions"));
    public static final class_5321<class_2378<List<class_1322>>> DRAGON_VARIANT_ATTRIBUTE_MODIFIERS = class_5321.method_29180((class_2960)UselessReptile.id("attribute_modifiers"));

    public static void init() {
        DynamicRegistries.registerSynced(DRAGON_MODEL, DragonModel.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(DRAGON_EQUIPMENT_INJECT, DragonEquipment.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(DRAGON_EQUIPMENT, DragonEquipment.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.register(DRAGON_SPAWN_CONDITIONS, (Codec)DragonSpawnConditions.CODEC.listOf());
        DynamicRegistries.register(DRAGON_VARIANT_ATTRIBUTE_MODIFIERS, (Codec)class_1322.field_46247.listOf());
        DynamicRegistries.registerSynced(DRAGON_VARIANT, DragonVariant.CODEC, DragonVariant.CODEC_NO_SERVER_INFO, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistries.registerSynced(DRAGON_VARIANT_CUSTOM_NAME, DragonVariant.CODEC_NO_SERVER_INFO, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        DynamicRegistrySetupCallback.EVENT.register(registryView -> {
            class_5455 registryManager = registryView.asDynamicRegistryManager();
            registryView.registerEntryAdded(DRAGON_VARIANT, (rawId, id, object) -> URRegistryKeys.verifyDragonVariantContent(registryManager, object, false));
            registryView.registerEntryAdded(DRAGON_VARIANT_CUSTOM_NAME, (rawId, id, object) -> URRegistryKeys.verifyDragonVariantContent(registryManager, object, true));
        });
    }

    private static void verifyDragonVariantContent(class_5455 registryManager, DragonVariant variant, boolean isCustomName) {
        String type = isCustomName ? "Custom name model" : "Variant";
        String name = variant.name();
        String entity = variant.dragonId().toString();
        if (registryManager.method_30530(DRAGON_MODEL).method_63535(variant.dragonModelData()) == null) {
            UselessReptile.LOGGER.warn("{} {} for {} specifies invalid dragon model path: {}", new Object[]{type, name, entity, variant.dragonModelData()});
        }
        if (registryManager.method_30530(DRAGON_EQUIPMENT).method_63535(variant.dragonEquipment()) == null) {
            UselessReptile.LOGGER.warn("{} {} for {} specifies invalid equipment path: {}", new Object[]{type, name, entity, variant.dragonEquipment()});
        }
        if (isCustomName) {
            return;
        }
        if (variant.spawnConditions().isPresent() && registryManager.method_30530(DRAGON_SPAWN_CONDITIONS).method_63535(variant.spawnConditions().get()) == null) {
            UselessReptile.LOGGER.warn("{} {} for {} specifies invalid spawn conditions path: {}", new Object[]{type, name, entity, variant.spawnConditions().get()});
        }
    }
}

