/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.datagen.data.mod;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import nordmods.uselessreptile.common.dragon_variant.model.DragonModel;
import nordmods.uselessreptile.common.dragon_variant.model.ModelData;
import nordmods.uselessreptile.common.init.UREntities;
import nordmods.uselessreptile.common.init.URSounds;

public class URDragonModelProvider
implements class_2405 {
    protected final FabricDataOutput output;
    private final class_7784.class_7489 pathResolver;
    private final CompletableFuture<class_7225.class_7874> registryLookupFuture;
    private final List<class_3545<class_2960, DragonModel>> holder = new ArrayList<class_3545<class_2960, DragonModel>>();

    public URDragonModelProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookupFuture) {
        this.output = output;
        this.pathResolver = output.method_45973(class_7784.class_7490.field_39367, "uselessreptile/dragon_model");
        this.registryLookupFuture = registryLookupFuture;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.registryLookupFuture.thenCompose(registryLookupFuture -> {
            this.addSpawnEntries();
            ArrayList list = new ArrayList();
            this.holder.forEach(entry -> {
                Path path = this.pathResolver.method_44107((class_2960)entry.method_15442());
                list.add(class_2405.method_53496((class_7403)writer, (class_7225.class_7874)registryLookupFuture, DragonModel.CODEC, (Object)((DragonModel)entry.method_15441()), (Path)path));
            });
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    protected void addSpawnEntries() {
        this.addWyvern("jeb_");
        this.addWyvern("green");
        this.addWyvern("brown");
        this.addMoleclaw("black");
        this.addMoleclaw("brown");
        this.addMoleclaw("grey");
        this.addMoleclaw("albino");
        this.addLightningChaser("blue");
        this.addLightningChaser("grey");
        this.addLightningChaser("brown");
        this.addLightningChaser("purple");
        this.addRiverPikehorn("green");
        this.addRiverPikehorn("dark_green");
        this.addRiverPikehorn("blue");
        this.addRiverPikehorn("dark_blue");
        this.addRiverPikehorn("purple");
        this.addRiverPikehorn("dark_purple");
        this.addRiverPikehorn("teal");
        this.addRiverPikehorn("dark_teal");
    }

    protected ModelData getModelData(class_2960 id, String variant, boolean cull) {
        class_2960 texture = class_2960.method_60655((String)id.method_12836(), (String)("entity/" + id.method_12832() + "/" + variant));
        class_2960 model = class_2960.method_60655((String)id.method_12836(), (String)("entity/" + id.method_12832() + "/" + id.method_12832()));
        class_2960 animation = class_2960.method_60655((String)id.method_12836(), (String)("entity/" + id.method_12832() + "/" + id.method_12832()));
        return new ModelData(texture, model, Optional.of(animation), cull, false);
    }

    protected void addWyvern(String variant) {
        ArrayList<DragonModel.Sound> sounds = new ArrayList<DragonModel.Sound>();
        sounds.add(new DragonModel.Sound("step", URSounds.WYVERN_STEP.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("woosh", URSounds.DRAGON_WOOSH.comp_3319(), Optional.of(Float.valueOf(2.0f)), Optional.empty()));
        sounds.add(new DragonModel.Sound("flap", class_3417.field_14550.comp_3319(), Optional.of(Float.valueOf(3.0f)), Optional.of(Float.valueOf(0.7f))));
        sounds.add(new DragonModel.Sound("shoot", class_3417.field_14934.comp_3319(), Optional.of(Float.valueOf(2.0f)), Optional.empty()));
        sounds.add(new DragonModel.Sound("bite", URSounds.WYVERN_BITE.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("idle", URSounds.WYVERN_AMBIENT.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("hurt", URSounds.WYVERN_HURT.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("death", URSounds.WYVERN_DEATH.comp_3319(), Optional.empty(), Optional.empty()));
        this.addEntry(UREntities.WYVERN_ENTITY, variant, Optional.of(sounds), true);
    }

    protected void addMoleclaw(String variant) {
        ArrayList<DragonModel.Sound> sounds = new ArrayList<DragonModel.Sound>();
        sounds.add(new DragonModel.Sound("step", URSounds.DRAGON_STEP.comp_3319(), Optional.empty(), Optional.of(Float.valueOf(0.7f))));
        sounds.add(new DragonModel.Sound("attack_strong", URSounds.MOLECLAW_STRONG_ATTACK.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("attack", URSounds.MOLECLAW_ATTACK.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("idle", URSounds.MOLECLAW_AMBIENT.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("hurt", URSounds.MOLECLAW_HURT.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("death", URSounds.MOLECLAW_DEATH.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("panic", URSounds.MOLECLAW_PANICKING.comp_3319(), Optional.empty(), Optional.empty()));
        this.addEntry(UREntities.MOLECLAW_ENTITY, variant, Optional.of(sounds), false);
    }

    protected void addRiverPikehorn(String variant) {
        ArrayList<DragonModel.Sound> sounds = new ArrayList<DragonModel.Sound>();
        sounds.add(new DragonModel.Sound("step", class_3417.field_14685.comp_3319(), Optional.of(Float.valueOf(0.5f)), Optional.of(Float.valueOf(0.8f))));
        sounds.add(new DragonModel.Sound("woosh", URSounds.DRAGON_WOOSH.comp_3319(), Optional.of(Float.valueOf(0.7f)), Optional.of(Float.valueOf(1.2f))));
        sounds.add(new DragonModel.Sound("flap", class_3417.field_14550.comp_3319(), Optional.empty(), Optional.of(Float.valueOf(1.2f))));
        sounds.add(new DragonModel.Sound("attack", URSounds.PIKEHORN_ATTACK.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("idle", URSounds.PIKEHORN_AMBIENT.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("hurt", URSounds.PIKEHORN_HURT.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("death", URSounds.PIKEHORN_DEATH.comp_3319(), Optional.empty(), Optional.empty()));
        this.addEntry(UREntities.RIVER_PIKEHORN_ENTITY, variant, Optional.of(sounds), true);
    }

    protected void addLightningChaser(String variant) {
        ArrayList<DragonModel.Sound> sounds = new ArrayList<DragonModel.Sound>();
        sounds.add(new DragonModel.Sound("step", URSounds.DRAGON_STEP.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("woosh", URSounds.DRAGON_WOOSH.comp_3319(), Optional.of(Float.valueOf(2.0f)), Optional.empty()));
        sounds.add(new DragonModel.Sound("flap", class_3417.field_14550.comp_3319(), Optional.of(Float.valueOf(3.0f)), Optional.of(Float.valueOf(0.6f))));
        sounds.add(new DragonModel.Sound("flap_heavy", class_3417.field_14550.comp_3319(), Optional.of(Float.valueOf(3.0f)), Optional.of(Float.valueOf(0.5f))));
        sounds.add(new DragonModel.Sound("bite", URSounds.LIGHTNING_CHASER_BITE.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("idle", URSounds.LIGHTNING_CHASER_AMBIENT.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("roar", URSounds.LIGHTNING_CHASER_DISTANT_ROAR.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("accept_challenge", URSounds.LIGHTNING_CHASER_ACCEPT_CHALLENGE.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("hurt", URSounds.LIGHTNING_CHASER_HURT.comp_3319(), Optional.empty(), Optional.empty()));
        sounds.add(new DragonModel.Sound("death", URSounds.LIGHTNING_CHASER_DEATH.comp_3319(), Optional.empty(), Optional.empty()));
        this.addEntry(UREntities.LIGHTNING_CHASER_ENTITY, variant, Optional.of(sounds), true);
    }

    protected void addEntry(class_2960 id, DragonModel variant) {
        this.holder.add((class_3545<class_2960, DragonModel>)new class_3545((Object)id, (Object)variant));
    }

    protected void addEntry(class_2960 dragonId, String variant, Optional<List<DragonModel.Sound>> sounds, boolean cull) {
        this.addEntry(this.id(dragonId, variant), new DragonModel(this.getModelData(dragonId, variant, cull), sounds));
    }

    protected void addEntry(class_1299<? extends class_1297> entityType, String variant, Optional<List<DragonModel.Sound>> sounds, boolean cull) {
        this.addEntry(class_1299.method_5890(entityType), variant, sounds, cull);
    }

    protected class_2960 id(class_2960 dragonId, String variant) {
        return class_2960.method_60655((String)dragonId.method_12836(), (String)(dragonId.method_12832() + "/" + variant));
    }

    public String method_10321() {
        return "Dragon Model";
    }
}

