/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.client.renderer.base;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.minecraft.class_10042;
import net.minecraft.class_10630;
import net.minecraft.class_10932;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_9974;
import nordmods.uselessreptile.client.config.URClientConfig;
import nordmods.uselessreptile.client.init.URDataTickets;
import nordmods.uselessreptile.client.model.DragonEqupmentModel;
import nordmods.uselessreptile.client.model.URDragonModel;
import nordmods.uselessreptile.client.renderer.base.DragonEquipmentRenderer;
import nordmods.uselessreptile.client.renderer.layers.URGlowingLayer;
import nordmods.uselessreptile.client.renderer.special.SaddleEquipmentRenderer;
import nordmods.uselessreptile.client.util.AssetCache;
import nordmods.uselessreptile.client.util.DragonAssetCache;
import nordmods.uselessreptile.client.util.DragonEquipmentAnimatable;
import nordmods.uselessreptile.client.util.RenderUtil;
import nordmods.uselessreptile.client.util.ResourceUtil;
import nordmods.uselessreptile.common.entity.base.ShooterDragon;
import nordmods.uselessreptile.common.entity.base.URDragonEntity;
import nordmods.uselessreptile.common.entity.misc.ShootingPoint;
import nordmods.uselessreptile.common.init.URTags;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public abstract class URDragonEntityRenderer<T extends URDragonEntity, R extends class_10042>
extends GeoEntityRenderer<T, R> {
    private final DragonEquipmentRenderer dragonEquipmentRenderer = new DragonEquipmentRenderer();
    private final SaddleEquipmentRenderer saddleEquipmentRenderer = new SaddleEquipmentRenderer();

    public URDragonEntityRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, new URDragonModel());
        this.addRenderLayer(new URGlowingLayer(this, state -> (AssetCache)((GeoRenderState)state).getGeckolibData(URDataTickets.DRAGON_ASSET_CACHE)));
    }

    protected float getShadowRadius(R state) {
        return super.method_55831(state) * ((class_10042)state).field_53453;
    }

    public void postRender(R dragonRenderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        super.postRender(dragonRenderState, poseStack, model, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        if (!ResourceUtil.isResourceReloadFinished) {
            return;
        }
        DragonAssetCache dragonAssetCache = (DragonAssetCache)((GeoRenderState)dragonRenderState).getGeckolibData(URDataTickets.DRAGON_ASSET_CACHE);
        class_10630 equipment = (class_10630)((GeoRenderState)dragonRenderState).getGeckolibData(URDataTickets.DRAGON_EQIPMENT);
        for (class_1304 slot : class_1304.values()) {
            class_1799 itemStack = equipment.method_66659(slot);
            if (itemStack == null || itemStack.method_7960()) {
                dragonAssetCache.setEquipmentAnimatable(slot, null);
                continue;
            }
            DragonEquipmentAnimatable dragonEquipmentAnimatable = dragonAssetCache.getEquipmentAnimatable(slot);
            if (dragonEquipmentAnimatable == null || dragonEquipmentAnimatable.item != itemStack.method_7909()) {
                dragonEquipmentAnimatable = new DragonEquipmentAnimatable((GeoRenderState)dragonRenderState, itemStack.method_7909());
                dragonAssetCache.setEquipmentAnimatable(slot, dragonEquipmentAnimatable);
            } else {
                dragonEquipmentAnimatable.ownerRenderState = (GeoRenderState)dragonRenderState;
            }
            DragonEquipmentRenderer usedRenderer = itemStack.method_31573(URTags.DRAGON_SADDLES) ? this.saddleEquipmentRenderer : this.dragonEquipmentRenderer;
            GeoRenderState.Impl temp = new GeoRenderState.Impl();
            usedRenderer.addRenderData(dragonEquipmentAnimatable, null, (GeoRenderState)temp);
            class_2960 id = usedRenderer.getGeoModel().getModelResource((GeoRenderState)temp);
            if (id == DragonEqupmentModel.DEFAULT_MODEL) continue;
            BakedGeoModel bakedEquipmentModel = usedRenderer.getGeoModel().getBakedModel(id);
            id = usedRenderer.getGeoModel().getTextureResource((GeoRenderState)temp);
            Map<String, GeoBone> equipmentBones = dragonEquipmentAnimatable.equipmentBones;
            if (equipmentBones.isEmpty()) {
                this.getEquipmentBones(equipmentBones, bakedEquipmentModel);
            }
            this.getGeoModel().getAnimationProcessor().getRegisteredBones().forEach(bone -> {
                GeoBone equipmentBone = (GeoBone)equipmentBones.get(bone.getName());
                if (equipmentBone != null) {
                    equipmentBone.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
                    equipmentBone.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                    equipmentBone.updatePosition(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                }
            });
            class_1921 renderType = usedRenderer.getGeoModel().getRenderType((GeoRenderState)temp, id);
            usedRenderer.render(poseStack, dragonEquipmentAnimatable, bufferSource, renderType, bufferSource.getBuffer(renderType), packedLight, RenderUtil.getTickDelta(false));
        }
    }

    private void addChildren(Map<String, GeoBone> equipmentBones, GeoBone bone) {
        equipmentBones.put(bone.getName(), bone);
        for (GeoBone child : bone.getChildBones()) {
            this.addChildren(equipmentBones, child);
        }
    }

    private void getEquipmentBones(Map<String, GeoBone> equipmentBones, BakedGeoModel model) {
        for (GeoBone bone : model.topLevelBones()) {
            this.addChildren(equipmentBones, bone);
        }
    }

    public void addRenderData(T animatable, Void relatedObject, R renderState) {
        ((GeoRenderState)renderState).addGeckolibData(URDataTickets.DRAGON_ID, (Object)((URDragonEntity)animatable).getDragonId());
        ((GeoRenderState)renderState).addGeckolibData(URDataTickets.DRAGON_VARIANT, (Object)((URDragonEntity)animatable).getVariant());
        ((GeoRenderState)renderState).addGeckolibData(URDataTickets.DRAGON_NAME, (Object)animatable.method_5797());
        ((GeoRenderState)renderState).addGeckolibData(URDataTickets.DRAGON_ASSET_CACHE, (Object)((URDragonEntity)animatable).getAssetCache());
        if (animatable instanceof ShooterDragon) {
            ShooterDragon shooterDragon = (ShooterDragon)animatable;
            ((GeoRenderState)renderState).addGeckolibData(URDataTickets.DRAGON_SHOOTING_POINT, (Object)shooterDragon.getShootingPoint());
        }
        class_10630 map = new class_10630();
        for (class_1304 slot : class_1304.values()) {
            map.method_66660(slot, animatable.method_6118(slot));
        }
        ((GeoRenderState)renderState).addGeckolibData(URDataTickets.DRAGON_EQIPMENT, (Object)map);
    }

    protected void appendHitboxes(T entity, ImmutableList.Builder<class_10932> builder, float tickDelta) {
        super.method_68827(entity, builder, tickDelta);
        if (URClientConfig.getConfig().attackBoxesInDebug) {
            double x = -entity.method_23317();
            double y = -entity.method_23318();
            double z = -entity.method_23321();
            class_238 box = entity.method_53511();
            if (box != null) {
                builder.add((Object)new class_10932(box.field_1323 + x, box.field_1322 + y, box.field_1321 + z, box.field_1320 + x, box.field_1325 + y, box.field_1324 + z, 1.0f, 0.0f, 1.0f));
            }
            if ((box = ((URDragonEntity)entity).getSecondaryAttackBox()) != null) {
                builder.add((Object)new class_10932(box.field_1323 + x, box.field_1322 + y, box.field_1321 + z, box.field_1320 + x, box.field_1325 + y, box.field_1324 + z, 1.0f, 0.0f, 0.25f));
            }
        }
    }

    public void actuallyRender(R renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        super.actuallyRender(renderState, poseStack, model, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        if (((class_10042)renderState).field_58169 != null && ((GeoRenderState)renderState).hasGeckolibData(URDataTickets.DRAGON_SHOOTING_POINT)) {
            poseStack.method_22903();
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f + ((class_10042)renderState).field_53446));
            class_4588 buf = bufferSource.getBuffer(class_1921.method_23594());
            ShootingPoint point = (ShootingPoint)((GeoRenderState)renderState).getGeckolibData(URDataTickets.DRAGON_SHOOTING_POINT);
            class_243 pos = point.pos().method_1020(new class_243(((class_10042)renderState).field_53325, ((class_10042)renderState).field_53326, ((class_10042)renderState).field_53327));
            class_243 rot = point.rotation();
            class_9974.method_62298((class_4587)poseStack, (class_4588)buf, (Vector3f)pos.method_46409(), (class_243)rot.method_1021(5.0), (int)-65521);
            poseStack.method_22909();
        }
    }
}

