/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.common.dragon_variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import nordmods.uselessreptile.UselessReptile;
import nordmods.uselessreptile.common.entity.base.URDragonEntity;
import nordmods.uselessreptile.common.init.URRegistryKeys;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DragonVariant(class_2960 dragonId, String name, Optional<String> displayNameKey, class_2960 dragonModelData, class_2960 dragonEquipment, Optional<class_2960> spawnConditions, Optional<class_2960> variantAttributeModifiers, int baseTamingProgress, Optional<List<TamingItem>> tamingItems, Optional<List<FoodItem>> foodItems) {
    public static final Codec<DragonVariant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(DragonVariant::dragonId), (App)Codec.STRING.fieldOf("name").forGetter(DragonVariant::name), (App)Codec.STRING.optionalFieldOf("display_name_key").forGetter(DragonVariant::displayNameKey), (App)class_2960.field_25139.fieldOf("dragon_model").forGetter(DragonVariant::dragonModelData), (App)class_2960.field_25139.fieldOf("equipment").forGetter(DragonVariant::dragonEquipment), (App)class_2960.field_25139.optionalFieldOf("spawn_conditions").forGetter(DragonVariant::spawnConditions), (App)class_2960.field_25139.optionalFieldOf("attribute_modifiers").forGetter(DragonVariant::variantAttributeModifiers), (App)Codec.INT.fieldOf("base_taming_progress").forGetter(DragonVariant::baseTamingProgress), (App)TamingItem.LIST_CODEC.optionalFieldOf("taming_items").forGetter(DragonVariant::tamingItems), (App)FoodItem.LIST_CODEC.optionalFieldOf("food_items").forGetter(DragonVariant::foodItems)).apply((Applicative)instance, DragonVariant::new));
    public static final Codec<DragonVariant> CODEC_NO_SERVER_INFO = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(DragonVariant::dragonId), (App)Codec.STRING.fieldOf("name").forGetter(DragonVariant::name), (App)Codec.STRING.optionalFieldOf("display_name_key").forGetter(DragonVariant::displayNameKey), (App)class_2960.field_25139.fieldOf("dragon_model").forGetter(DragonVariant::dragonModelData), (App)class_2960.field_25139.fieldOf("equipment").forGetter(DragonVariant::dragonEquipment), (App)TamingItem.LIST_CODEC.optionalFieldOf("taming_items").forGetter(DragonVariant::tamingItems), (App)FoodItem.LIST_CODEC.optionalFieldOf("food_items").forGetter(DragonVariant::foodItems)).apply((Applicative)instance, (id, variant, displayNameKey, dragonModelData, dragonEquipment, tamingItemList, foodItemList) -> new DragonVariant((class_2960)id, (String)variant, (Optional<String>)displayNameKey, (class_2960)dragonModelData, (class_2960)dragonEquipment, Optional.empty(), Optional.empty(), 0, (Optional<List<TamingItem>>)tamingItemList, (Optional<List<FoodItem>>)foodItemList)));
    public static final Codec<DragonVariant> CODEC_CUSTOM_NAME = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(DragonVariant::dragonId), (App)Codec.STRING.fieldOf("name").forGetter(DragonVariant::name), (App)class_2960.field_25139.fieldOf("dragon_model").forGetter(DragonVariant::dragonModelData), (App)class_2960.field_25139.fieldOf("equipment").forGetter(DragonVariant::dragonEquipment)).apply((Applicative)instance, (id, variant, dragonModelData, dragonEquipment) -> new DragonVariant((class_2960)id, (String)variant, Optional.empty(), (class_2960)dragonModelData, (class_2960)dragonEquipment, Optional.empty(), Optional.empty(), 0, Optional.empty(), Optional.empty())));

    @NotNull
    public static DragonVariant getDefaultVariant(class_2960 dragonId, class_1937 world) {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10582("id", dragonId.toString());
        URDragonEntity dragon = (URDragonEntity)class_1299.method_5892((class_11368)class_11352.method_71417((class_8942)UselessReptile.ERROR_REPORTER, (class_7225.class_7874)world.method_30349(), (class_2487)nbtCompound), (class_1937)world, (class_3730)class_3730.field_16461).get();
        dragon.method_31472();
        return dragon.method_37908().method_30349().method_30530(URRegistryKeys.DRAGON_VARIANT).method_10220().filter(dragonVariant -> dragonVariant.dragonId().equals((Object)dragon.getDragonId()) && dragonVariant.name().equals(dragon.getDefaultVariant())).findFirst().orElseThrow();
    }

    @Nullable
    public static DragonVariant getByVariant(class_2960 dragonId, String variant, class_1937 world) {
        class_2378 registry = world.method_30349().method_30530(URRegistryKeys.DRAGON_VARIANT);
        return registry.method_10220().filter(dragonVariant -> dragonVariant.dragonId().equals((Object)dragonId) && dragonVariant.name().equals(variant)).findFirst().orElse(null);
    }

    @Nullable
    public static DragonVariant getByCustomName(class_2960 dragonId, String name, class_1937 world) {
        class_2378 registry = world.method_30349().method_30530(URRegistryKeys.DRAGON_VARIANT_CUSTOM_NAME);
        return registry.method_10220().filter(dragonVariant -> dragonVariant.dragonId().equals((Object)dragonId) && dragonVariant.name().equals(name)).findFirst().orElse(null);
    }

    public static DragonVariant getDragonVariant(class_2960 dragonId, String name, String variant, class_1937 world) {
        DragonVariant dragonVariant = null;
        if (name != null) {
            dragonVariant = DragonVariant.getByCustomName(dragonId, name, world);
        }
        if (dragonVariant != null) {
            return dragonVariant;
        }
        dragonVariant = DragonVariant.getByVariant(dragonId, variant, world);
        if (dragonVariant != null) {
            return dragonVariant;
        }
        return DragonVariant.getDefaultVariant(dragonId, world);
    }

    public record TamingItem(class_5699.class_7476 item, Pair<Integer, Integer> tamingProgressIncrease) {
        private static final Codec<Pair<Integer, Integer>> PAIR_CODEC = Codec.pair((Codec)class_5699.field_33441.fieldOf("min").codec(), (Codec)class_5699.field_33442.fieldOf("max").codec());
        private static final Codec<Pair<Integer, Integer>> PAIR_WITH_ALTERNATIVE = Codec.withAlternative((Codec)Codec.INT_STREAM.comapFlatMap(stream -> class_156.method_29190((IntStream)stream, (int)2).map(values -> new Pair((Object)values[0], (Object)values[1])), pair -> IntStream.of((Integer)pair.getFirst(), (Integer)pair.getSecond())).stable(), PAIR_CODEC);
        public static final Codec<TamingItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_39274.fieldOf("item").forGetter(TamingItem::item), (App)PAIR_WITH_ALTERNATIVE.fieldOf("taming_progress_increase").forGetter(TamingItem::tamingProgressIncrease)).apply((Applicative)instance, TamingItem::new));
        public static final Codec<List<TamingItem>> LIST_CODEC = Codec.withAlternative((Codec)Codec.unboundedMap((Codec)class_5699.field_39274, PAIR_WITH_ALTERNATIVE).xmap(tagEntryIdIntegerMap -> tagEntryIdIntegerMap.entrySet().stream().map(entry -> new TamingItem((class_5699.class_7476)entry.getKey(), (Pair<Integer, Integer>)((Pair)entry.getValue()))).toList(), list -> {
            HashMap map = new HashMap();
            list.forEach(tamingItem -> map.put(tamingItem.item(), tamingItem.tamingProgressIncrease()));
            return map;
        }), (Codec)CODEC.listOf());
    }

    public record FoodItem(class_5699.class_7476 item, Integer healingAmount) {
        public static final Codec<FoodItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_39274.fieldOf("item").forGetter(FoodItem::item), (App)class_5699.field_33441.fieldOf("healing_amount").forGetter(FoodItem::healingAmount)).apply((Applicative)instance, FoodItem::new));
        public static final Codec<List<FoodItem>> LIST_CODEC = Codec.withAlternative((Codec)Codec.unboundedMap((Codec)class_5699.field_39274, (Codec)class_5699.field_33441).xmap(tagEntryIdIntegerMap -> tagEntryIdIntegerMap.entrySet().stream().map(entry -> new FoodItem((class_5699.class_7476)entry.getKey(), (Integer)entry.getValue())).toList(), list -> {
            HashMap map = new HashMap();
            list.forEach(foodItem -> map.put(foodItem.item(), foodItem.healingAmount()));
            return map;
        }), (Codec)CODEC.listOf());
    }
}

