/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.common.dragon_variant.spawn;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;

public record DragonSpawnConditions(int weight, Optional<List<class_5699.class_7476>> allowedBiomes, Optional<List<class_5699.class_7476>> bannedBiomes, Optional<List<class_5699.class_7476>> allowedBlocks, Optional<List<class_5699.class_7476>> bannedBlocks, Optional<AltitudeRestriction> altitudeRestriction) {
    public static final Codec<DragonSpawnConditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("weight").forGetter(DragonSpawnConditions::weight), (App)class_5699.field_39274.listOf().optionalFieldOf("allowed_biomes").forGetter(DragonSpawnConditions::allowedBiomes), (App)class_5699.field_39274.listOf().optionalFieldOf("banned_biomes").forGetter(DragonSpawnConditions::bannedBiomes), (App)class_5699.field_39274.listOf().optionalFieldOf("allowed_blocks").forGetter(DragonSpawnConditions::allowedBlocks), (App)class_5699.field_39274.listOf().optionalFieldOf("banned_blocks").forGetter(DragonSpawnConditions::bannedBlocks), (App)AltitudeRestriction.CODEC.optionalFieldOf("altitude").forGetter(DragonSpawnConditions::altitudeRestriction)).apply((Applicative)instance, DragonSpawnConditions::new));

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer weight;
        private List<class_5699.class_7476> allowedBiomes;
        private List<class_5699.class_7476> bannedBiomes;
        private List<class_5699.class_7476> allowedBlocks;
        private List<class_5699.class_7476> bannedBlocks;
        private Integer minAltitude;
        private Integer maxAltitude;

        private Builder() {
        }

        public DragonSpawnConditions build() {
            Optional<AltitudeRestriction> altitudeRestriction;
            Optional<List<class_5699.class_7476>> bannedBlocks;
            if (this.weight == null) {
                throw new IllegalStateException("Weight must be specified");
            }
            Optional<List<class_5699.class_7476>> allowedBiomes = this.allowedBiomes != null ? Optional.of(this.allowedBiomes) : Optional.empty();
            Optional<List<class_5699.class_7476>> bannedBiomes = this.bannedBiomes != null ? Optional.of(this.bannedBiomes) : Optional.empty();
            Optional<List<class_5699.class_7476>> allowedBlocks = this.allowedBlocks != null ? Optional.of(this.allowedBlocks) : Optional.empty();
            Optional<List<class_5699.class_7476>> optional = bannedBlocks = this.bannedBlocks != null ? Optional.of(this.bannedBlocks) : Optional.empty();
            if (this.minAltitude != null || this.maxAltitude != null) {
                Optional<Integer> minAltitude = this.minAltitude != null ? Optional.of(this.minAltitude) : Optional.empty();
                Optional<Integer> maxAltitude = this.maxAltitude != null ? Optional.of(this.maxAltitude) : Optional.empty();
                altitudeRestriction = Optional.of(new AltitudeRestriction(minAltitude, maxAltitude));
            } else {
                altitudeRestriction = Optional.empty();
            }
            return new DragonSpawnConditions(this.weight, allowedBiomes, bannedBiomes, allowedBlocks, bannedBlocks, altitudeRestriction);
        }

        public Builder setWeight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public Builder setMinAltitude(Integer minAltitude) {
            this.minAltitude = minAltitude;
            return this;
        }

        public Builder setMaxAltitude(Integer maxAltitude) {
            this.maxAltitude = maxAltitude;
            return this;
        }

        public Builder addAllowedBiome(class_5321<class_1959> biomeRegistryKey) {
            if (this.allowedBiomes == null) {
                this.allowedBiomes = new ArrayList<class_5699.class_7476>();
            }
            this.allowedBiomes.add(new class_5699.class_7476(biomeRegistryKey.method_29177(), false));
            return this;
        }

        public Builder addAllowedBiomeTag(class_6862<class_1959> biomeTagKey) {
            if (this.allowedBiomes == null) {
                this.allowedBiomes = new ArrayList<class_5699.class_7476>();
            }
            this.allowedBiomes.add(new class_5699.class_7476(biomeTagKey.comp_327(), true));
            return this;
        }

        public Builder addBannedBiome(class_5321<class_1959> biomeRegistryKey) {
            if (this.bannedBiomes == null) {
                this.bannedBiomes = new ArrayList<class_5699.class_7476>();
            }
            this.bannedBiomes.add(new class_5699.class_7476(biomeRegistryKey.method_29177(), false));
            return this;
        }

        public Builder addBannedBiomeTag(class_6862<class_1959> biomeTagKey) {
            if (this.bannedBiomes == null) {
                this.bannedBiomes = new ArrayList<class_5699.class_7476>();
            }
            this.bannedBiomes.add(new class_5699.class_7476(biomeTagKey.comp_327(), true));
            return this;
        }

        public Builder addAllowedBlock(class_5321<class_2248> blockRegistryKey) {
            if (this.allowedBlocks == null) {
                this.allowedBlocks = new ArrayList<class_5699.class_7476>();
            }
            this.allowedBlocks.add(new class_5699.class_7476(blockRegistryKey.method_29177(), false));
            return this;
        }

        public Builder addAllowedBlockTag(class_6862<class_2248> blockTagKey) {
            if (this.allowedBlocks == null) {
                this.allowedBlocks = new ArrayList<class_5699.class_7476>();
            }
            this.allowedBlocks.add(new class_5699.class_7476(blockTagKey.comp_327(), true));
            return this;
        }

        public Builder addBannedBlock(class_5321<class_2248> blockRegistryKey) {
            if (this.bannedBlocks == null) {
                this.bannedBlocks = new ArrayList<class_5699.class_7476>();
            }
            this.bannedBlocks.add(new class_5699.class_7476(blockRegistryKey.method_29177(), false));
            return this;
        }

        public Builder addBannedBlockTag(class_6862<class_2248> blockTagKey) {
            if (this.bannedBlocks == null) {
                this.bannedBlocks = new ArrayList<class_5699.class_7476>();
            }
            this.bannedBlocks.add(new class_5699.class_7476(blockTagKey.comp_327(), true));
            return this;
        }
    }

    public record AltitudeRestriction(Pair<Optional<Integer>, Optional<Integer>> range) {
        public static final Codec<Pair<Optional<Integer>, Optional<Integer>>> PAIR_CODEC = Codec.withAlternative((Codec)Codec.pair((Codec)Codec.INT.optionalFieldOf("min").codec(), (Codec)Codec.INT.optionalFieldOf("max").codec()), (Codec)Codec.INT_STREAM.comapFlatMap(stream -> class_156.method_29190((IntStream)stream, (int)2).map(values -> new Pair(Optional.of(values[0]), Optional.of(values[1]))), pair -> IntStream.of(((Optional)pair.getFirst()).orElse(Integer.MIN_VALUE), ((Optional)pair.getSecond()).orElse(Integer.MAX_VALUE))).stable());
        public static final Codec<AltitudeRestriction> CODEC = PAIR_CODEC.comapFlatMap(range1 -> DataResult.success((Object)new AltitudeRestriction((Pair<Optional<Integer>, Optional<Integer>>)range1)), AltitudeRestriction::range).stable();

        public AltitudeRestriction(Optional<Integer> min, Optional<Integer> max) {
            this((Pair<Optional<Integer>, Optional<Integer>>)new Pair(min, max));
        }

        public int getMin() {
            return ((Optional)this.range.getFirst()).orElse(Integer.MIN_VALUE);
        }

        public int getMax() {
            return ((Optional)this.range.getSecond()).orElse(Integer.MAX_VALUE);
        }
    }
}

