/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.common.dragon_variant.spawn;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import nordmods.uselessreptile.UselessReptile;
import nordmods.uselessreptile.common.dragon_variant.DragonVariant;
import nordmods.uselessreptile.common.dragon_variant.spawn.DragonSpawnConditions;
import nordmods.uselessreptile.common.entity.base.URDragonEntity;
import nordmods.uselessreptile.common.init.URRegistryKeys;

public class DragonSpawnUtil {
    public static boolean isBiomeInList(List<class_5699.class_7476> list, class_6880<class_1959> biome) {
        for (class_5699.class_7476 tagEntryId : list) {
            if (!(tagEntryId.comp_814() ? biome.method_40220(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tagEntryId.comp_813())) : biome.method_40226(tagEntryId.comp_813()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockInList(List<class_5699.class_7476> list, class_6880<class_2248> block) {
        for (class_5699.class_7476 tagEntryId : list) {
            if (!(tagEntryId.comp_814() ? block.method_40220(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tagEntryId.comp_813())) : block.method_40226(tagEntryId.comp_813()))) continue;
            return true;
        }
        return false;
    }

    public static void assignAvailableVariant(URDragonEntity entity, class_3730 spawnReason) {
        class_2338 pos = entity.method_24515();
        class_1937 world = entity.method_37908();
        class_2960 id = entity.getDragonId();
        Stream<DragonVariant> variantStream = DragonSpawnUtil.getAvailableVariants((class_1936)world, pos, id);
        boolean canWarn = spawnReason == class_3730.field_16459 || spawnReason == class_3730.field_16467 || spawnReason == class_3730.field_16472 || spawnReason == class_3730.field_16466;
        class_5455 registryManager = entity.method_37908().method_30349();
        ArrayList variants = new ArrayList();
        variantStream.forEach(arg_0 -> DragonSpawnUtil.lambda$assignAvailableVariant$1(registryManager, (class_1936)world, pos, variants, arg_0));
        if (variants.isEmpty()) {
            if (canWarn) {
                UselessReptile.LOGGER.warn("Failed to set variant for {} at {} as none can spawn there. Setting default", (Object)entity.method_5477().getString(), (Object)entity.method_24515());
            }
            entity.setVariant(entity.getDefaultVariant());
            return;
        }
        int totalWeight = 0;
        for (class_3545 variant : variants) {
            totalWeight += ((Integer)variant.method_15441()).intValue();
        }
        int roll = entity.method_59922().method_43048(totalWeight);
        int previousBound = 0;
        for (class_3545 variant : variants) {
            if (roll >= previousBound && roll < previousBound + (Integer)variant.method_15441()) {
                entity.setVariant((String)variant.method_15442());
                break;
            }
            previousBound += ((Integer)variant.method_15441()).intValue();
        }
    }

    public static Stream<DragonVariant> getAvailableVariants(class_1936 world, class_2338 pos, class_2960 dragonId) {
        class_5455 registryManager = world.method_30349();
        return DragonSpawnUtil.getAllVariants(world, dragonId).filter(variant -> {
            for (DragonSpawnConditions conditions : (List)registryManager.method_30530(URRegistryKeys.DRAGON_SPAWN_CONDITIONS).method_63535(variant.spawnConditions().get())) {
                if (!DragonSpawnUtil.checkConditions(conditions, world, pos)) continue;
                return true;
            }
            return false;
        });
    }

    public static Stream<DragonVariant> getAllVariants(class_1936 world, class_2960 dragonId) {
        class_5455 registryManager = world.method_30349();
        return registryManager.method_30530(URRegistryKeys.DRAGON_VARIANT).method_10220().filter(variant -> variant.dragonId().equals((Object)dragonId)).filter(variant -> {
            if (variant.spawnConditions().isPresent()) {
                List conditionsList = (List)registryManager.method_30530(URRegistryKeys.DRAGON_SPAWN_CONDITIONS).method_63535(variant.spawnConditions().get());
                if (conditionsList == null) {
                    return false;
                }
                for (DragonSpawnConditions conditions : conditionsList) {
                    if (conditions.weight() <= 0) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private static boolean checkConditions(DragonSpawnConditions conditions, class_1936 world, class_2338 pos) {
        List<class_5699.class_7476> list;
        List<class_5699.class_7476> list2;
        DragonSpawnConditions.AltitudeRestriction restriction;
        if (conditions.altitudeRestriction().isPresent() && ((restriction = conditions.altitudeRestriction().get()).getMin() > pos.method_10264() || restriction.getMax() <= pos.method_10264())) {
            return false;
        }
        class_6880 biome = world.method_23753(pos);
        if (conditions.allowedBiomes().isPresent() && !(list2 = conditions.allowedBiomes().get()).isEmpty() && !DragonSpawnUtil.isBiomeInList(list2, (class_6880<class_1959>)biome)) {
            return false;
        }
        if (conditions.bannedBiomes().isPresent() && !(list2 = conditions.bannedBiomes().get()).isEmpty() && DragonSpawnUtil.isBiomeInList(list2, (class_6880<class_1959>)biome)) {
            return false;
        }
        class_6880 block = world.method_8320(pos.method_10074()).method_41520();
        if (conditions.allowedBlocks().isPresent() && !(list = conditions.allowedBlocks().get()).isEmpty() && !DragonSpawnUtil.isBlockInList(list, (class_6880<class_2248>)block)) {
            return false;
        }
        return !conditions.bannedBlocks().isPresent() || (list = conditions.bannedBlocks().get()).isEmpty() || !DragonSpawnUtil.isBlockInList(list, (class_6880<class_2248>)block);
    }

    private static /* synthetic */ void lambda$assignAvailableVariant$1(class_5455 registryManager, class_1936 world, class_2338 pos, List variants, DragonVariant variant) {
        ((List)registryManager.method_30530(URRegistryKeys.DRAGON_SPAWN_CONDITIONS).method_63535(variant.spawnConditions().get())).forEach(conditions -> {
            if (DragonSpawnUtil.checkConditions(conditions, world, pos)) {
                variants.add(new class_3545((Object)variant.name(), (Object)conditions.weight()));
            }
        });
    }
}

