/*
 * Decompiled with CFR 0.152.
 */
package nordmods.uselessreptile.common.entity.misc;

import java.util.function.Function;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import nordmods.uselessreptile.common.entity.base.URDragonEntity;
import org.jetbrains.annotations.Nullable;

public class DragonInventory
extends class_1277 {
    public static final int INVENTORY_START_INDEX = 5;
    public static final int SADDLE_INDEX = 0;
    public static final int HELMET_INDEX = 1;
    public static final int CHESTPLATE_INDEX = 2;
    public static final int TAIL_ARMOR_INDEX = 3;
    public static final int BANNER_INDEX = 4;
    public final StorageSize storageSize;
    public final boolean hasArmor;
    public final boolean hasSaddle;
    public final boolean hasBanner;
    public final Function<class_1799, Boolean> isSaddle;
    public final Function<class_1799, Boolean> isHelmet;
    public final Function<class_1799, Boolean> isChestplate;
    public final Function<class_1799, Boolean> isTailArmor;
    public final Function<class_1799, Boolean> isBanner;

    public DragonInventory(@Nullable URDragonEntity dragon, StorageSize storageSize, boolean hasArmor, boolean hasSaddle, boolean hasBanner) {
        super(DragonInventory.getInventorySize(storageSize));
        this.storageSize = storageSize;
        this.hasArmor = hasArmor;
        this.hasSaddle = hasSaddle;
        this.hasBanner = hasBanner;
        if (dragon == null) {
            this.isSaddle = itemStack -> false;
            this.isHelmet = itemStack -> false;
            this.isChestplate = itemStack -> false;
            this.isTailArmor = itemStack -> false;
            this.isBanner = itemStack -> false;
        } else {
            this.isSaddle = dragon::isSaddle;
            this.isHelmet = dragon::isHelmet;
            this.isChestplate = dragon::isChestplate;
            this.isTailArmor = dragon::isTailArmor;
            this.isBanner = dragon::isBanner;
        }
    }

    public boolean method_27070(class_1799 stack) {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!this.canInsertInSlot(stack, i)) continue;
            return true;
        }
        return false;
    }

    public boolean canInsertInSlot(class_1799 stack, int slot) {
        class_1799 itemStack = (class_1799)this.field_5828.get(slot);
        switch (slot) {
            case 0: {
                if (!this.hasSaddle || !itemStack.method_7960() || !this.isSaddle.apply(stack).booleanValue()) break;
                return true;
            }
            case 1: {
                if (!this.hasArmor || !itemStack.method_7960() || !this.isHelmet.apply(stack).booleanValue()) break;
                return true;
            }
            case 2: {
                if (!this.hasArmor || !itemStack.method_7960() || !this.isChestplate.apply(stack).booleanValue()) break;
                return true;
            }
            case 3: {
                if (!this.hasArmor || !itemStack.method_7960() || !this.isTailArmor.apply(stack).booleanValue()) break;
                return true;
            }
            case 4: {
                if (!this.hasBanner || !itemStack.method_7960() || !this.isBanner.apply(stack).booleanValue()) break;
                return true;
            }
            default: {
                if (!itemStack.method_7960() && (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack) || itemStack.method_7947() >= itemStack.method_7914())) break;
                return true;
            }
        }
        return false;
    }

    public class_1799 method_5491(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = stack.method_7972();
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!this.canInsertInSlot(stack, i)) continue;
            class_1799 target = this.method_5438(i);
            if (target.method_7960()) {
                this.method_5447(i, itemStack);
                return class_1799.field_8037;
            }
            this.transfer(itemStack, this.method_5438(i));
            if (!itemStack.method_7960()) continue;
            return class_1799.field_8037;
        }
        return itemStack;
    }

    public static int getInventorySize(StorageSize storageSize) {
        return storageSize.size + 5;
    }

    private void transfer(class_1799 source, class_1799 target) {
        int i = this.method_58350(target);
        int j = Math.min(source.method_7947(), i - target.method_7947());
        if (j > 0) {
            target.method_7933(j);
            source.method_7934(j);
            this.method_5431();
        }
    }

    public static enum StorageSize {
        NO_INVENTORY(-5),
        NONE(0),
        SMALL(3),
        MEDIUM(6),
        LARGE(9),
        VERY_LARGE(12),
        MAX(15);

        private final int size;

        private StorageSize(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }
}

