/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util.gui;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.util.LanguageManager;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.NumFormatter;
import com.zetaplugins.cookieclickerz.util.achievements.Achievement;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementCategory;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementType;
import com.zetaplugins.cookieclickerz.util.gui.GuiAssets;
import com.zetaplugins.cookieclickerz.util.items.CustomItem;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class AchievementGUI {
    private static final List<UUID> openInventories = new ArrayList<UUID>();

    private AchievementGUI() {
    }

    public static boolean isOpen(Player player) {
        return openInventories.contains(player.getUniqueId());
    }

    public static void open(Player player) {
        CookieClickerZ plugin = CookieClickerZ.getInstance();
        PlayerData playerData = plugin.getStorage().load(player.getUniqueId());
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtils.getAndFormatMsg(false, "inventories.achievements.title", "&8Achievements", new MessageUtils.Replaceable[0]));
        GuiAssets.fillInventoryWithGlass(inventory);
        inventory.setItem(0, AchievementGUI.getAchievementCategoryHead(AchievementCategory.CLICKS));
        inventory.setItem(9, AchievementGUI.getAchievementItem(playerData, AchievementType.CLICKER_ROOKIE));
        inventory.setItem(18, AchievementGUI.getAchievementItem(playerData, AchievementType.FINGER_WORKOUT));
        inventory.setItem(27, AchievementGUI.getAchievementItem(playerData, AchievementType.CLICK_CHAMPION));
        inventory.setItem(36, AchievementGUI.getAchievementItem(playerData, AchievementType.UNSTOPPABLE_CLICKER));
        inventory.setItem(45, AchievementGUI.getAchievementItem(playerData, AchievementType.COOKIE_MACHINE));
        inventory.setItem(2, AchievementGUI.getAchievementCategoryHead(AchievementCategory.COOKIES));
        inventory.setItem(11, AchievementGUI.getAchievementItem(playerData, AchievementType.FIRST_BATCH));
        inventory.setItem(20, AchievementGUI.getAchievementItem(playerData, AchievementType.COOKIE_CONNOISSEUR));
        inventory.setItem(29, AchievementGUI.getAchievementItem(playerData, AchievementType.COOKIE_COLLECTOR));
        inventory.setItem(38, AchievementGUI.getAchievementItem(playerData, AchievementType.COOKIE_HOARDER));
        inventory.setItem(47, AchievementGUI.getAchievementItem(playerData, AchievementType.COOKIE_OVERLORD));
        inventory.setItem(4, AchievementGUI.getAchievementCategoryHead(AchievementCategory.UPGRADES));
        inventory.setItem(13, AchievementGUI.getAchievementItem(playerData, AchievementType.SMART_SHOPPER));
        inventory.setItem(22, AchievementGUI.getAchievementItem(playerData, AchievementType.UPGRADE_MASTER));
        inventory.setItem(31, AchievementGUI.getAchievementItem(playerData, AchievementType.SAVVY_SPENDER));
        inventory.setItem(40, AchievementGUI.getAchievementItem(playerData, AchievementType.UPGRADE_ENTHUSIAST));
        inventory.setItem(49, AchievementGUI.getAchievementItem(playerData, AchievementType.GOTTA_UPGRADE_THEM_ALL));
        inventory.setItem(6, AchievementGUI.getAchievementCategoryHead(AchievementCategory.PRESTIGE));
        inventory.setItem(15, AchievementGUI.getAchievementItem(playerData, AchievementType.REBAKED_AND_READY));
        inventory.setItem(24, AchievementGUI.getAchievementItem(playerData, AchievementType.TWICE_AS_TASTY));
        inventory.setItem(33, AchievementGUI.getAchievementItem(playerData, AchievementType.THIRD_TIMES_A_CHARM));
        inventory.setItem(42, AchievementGUI.getAchievementItem(playerData, AchievementType.OOPS_I_DID_IT_AGAIN));
        inventory.setItem(51, AchievementGUI.getAchievementItem(playerData, AchievementType.OVEN_ETERNAL));
        inventory.setItem(8, AchievementGUI.getAchievementCategoryHead(AchievementCategory.EVENTS));
        inventory.setItem(17, AchievementGUI.getAchievementItem(playerData, AchievementType.EVENT_HORIZON));
        inventory.setItem(26, AchievementGUI.getAchievementItem(playerData, AchievementType.NOT_MY_COOKIES));
        inventory.setItem(35, AchievementGUI.getAchievementItem(playerData, AchievementType.SUGAR_RUSH));
        inventory.setItem(44, AchievementGUI.getAchievementItem(playerData, AchievementType.MONEY_MAGNET));
        inventory.setItem(53, AchievementGUI.getAchievementItem(playerData, AchievementType.OOF));
        player.openInventory(inventory);
        openInventories.add(player.getUniqueId());
    }

    private static ItemStack getAchievementItem(PlayerData playerData, AchievementType achievementType) {
        Object goal;
        Optional<Achievement> achievementOptional = playerData.getAchievement(achievementType);
        boolean isCompleted = false;
        Object progess = "0";
        Object object = goal = achievementType.getCategory() == AchievementCategory.COOKIES ? NumFormatter.formatBigInt(achievementType.getBigIntegerGoal()) : String.valueOf(achievementType.getGoal());
        if (achievementOptional.isPresent()) {
            Achievement achievement = achievementOptional.get();
            isCompleted = achievement.isCompleted();
            progess = "" + achievement.getProgress();
            if (achievement.getType().getCategory().equals((Object)AchievementCategory.COOKIES)) {
                progess = playerData.getTotalCookies().compareTo(achievement.getType().getBigIntegerGoal()) >= 0 ? NumFormatter.formatBigInt(achievement.getType().getBigIntegerGoal()) : NumFormatter.formatBigInt(playerData.getTotalCookies());
                goal = NumFormatter.formatBigInt(achievement.getType().getBigIntegerGoal());
            }
        }
        LanguageManager languageManager = CookieClickerZ.getInstance().getLanguageManager();
        String achievementName = languageManager.getString("achievements." + achievementType.getSlug() + ".name");
        String achievementDescription = languageManager.getString("achievements." + achievementType.getSlug() + ".description");
        String achievementCompleted = isCompleted ? languageManager.getString("inventories.achievements.completed") : languageManager.getString("inventories.achievements.notCompleted");
        return new CustomItem(isCompleted ? Material.LIME_DYE : Material.GRAY_DYE).setName(MessageUtils.getAndFormatMsg(false, "inventories.achievements.achievementTitle", "<#9932cc>%title%", new MessageUtils.Replaceable<String>("%title%", achievementName), new MessageUtils.Replaceable<String>("%completed%", achievementCompleted))).setLore(MessageUtils.getAndFormatMsgList("inventories.achievements.achievementDescription", new MessageUtils.Replaceable<String>("%description%", achievementDescription), new MessageUtils.Replaceable<Object>("%progress%", progess), new MessageUtils.Replaceable<Object>("%goal%", goal), new MessageUtils.Replaceable<String>("%completed%", achievementCompleted))).getItemStack();
    }

    private static ItemStack getAchievementCategoryHead(AchievementCategory category) {
        String name = CookieClickerZ.getInstance().getLanguageManager().getString("achievementCategories." + category.getSlug());
        if (name == null) {
            name = category.getSlug();
        }
        try {
            return CustomItem.fromSkullBase64(category.getHeadBase64(CookieClickerZ.getInstance())).setName(name).getItemStack();
        }
        catch (MalformedURLException e) {
            return new CustomItem(Material.SKELETON_SKULL).setName(name).getItemStack();
        }
    }

    public static void close(Player player) {
        if (AchievementGUI.isOpen(player)) {
            openInventories.remove(player.getUniqueId());
        }
    }
}

