/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util.gui;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.gui.GuiAssets;
import com.zetaplugins.cookieclickerz.util.items.CustomItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class PrestigeGUI {
    private static final List<UUID> openInventories = new ArrayList<UUID>();
    FileConfiguration config = CookieClickerZ.getInstance().getConfig();

    private PrestigeGUI() {
    }

    public static boolean isOpen(Player player) {
        return openInventories.contains(player.getUniqueId());
    }

    public static void open(Player player) {
        PlayerData playerData = CookieClickerZ.getInstance().getStorage().load(player.getUniqueId());
        if (playerData == null) {
            CookieClickerZ.getInstance().getLogger().warning("Player data not found for " + player.getName());
            return;
        }
        int firstSlot = 9;
        int rowSize = 9;
        int maxRows = 3;
        int maxSlots = 27;
        FileConfiguration config = CookieClickerZ.getInstance().getConfigManager().getPrestigeConfig();
        ConfigurationSection levelsSection = config.getConfigurationSection("levels");
        if (levelsSection == null) {
            CookieClickerZ.getInstance().getLogger().warning("Prestige levels configuration section is missing!");
            return;
        }
        List levelKeys = levelsSection.getKeys(false).stream().map(Integer::parseInt).sorted().collect(Collectors.toList());
        int rowsNeeded = Math.min(3, (int)Math.ceil((double)levelKeys.size() / 9.0));
        Inventory inventory = Bukkit.createInventory(null, (int)((rowsNeeded + 2) * 9), (Component)MessageUtils.getAndFormatMsg(false, "inventories.prestige.title", "&8Prestige", new MessageUtils.Replaceable[0]));
        GuiAssets.addBorder(inventory);
        GuiAssets.addBackButton(inventory);
        PrestigeGUI.addGlass(inventory);
        inventory.setItem(4, new CustomItem(Material.FEATHER).setName(MessageUtils.getAndFormatMsg(false, "inventories.prestige.prestige", "&6&lPrestige", new MessageUtils.Replaceable[0])).setLore(List.of(MessageUtils.getAndFormatMsg(false, "inventories.prestige.description", "&7Prestige to massively increase your cookie production!", new MessageUtils.Replaceable[0]), MessageUtils.formatMsg(" ", new MessageUtils.Replaceable[0]))).getItemStack());
        int index = 0;
        Iterator iterator = levelKeys.iterator();
        while (iterator.hasNext()) {
            int level = (Integer)iterator.next();
            int slot = 9 + index;
            if (slot >= 36) break;
            try {
                inventory.setItem(slot, GuiAssets.getPretsigeGlassItem(level, playerData));
            }
            catch (NumberFormatException e) {
                CookieClickerZ.getInstance().getLogger().warning("Invalid prestige level key: " + level);
            }
            ++index;
        }
        for (int i = 9 + index; i < 9 + rowsNeeded * 9; ++i) {
            inventory.setItem(i, GuiAssets.getGlassItem());
        }
        player.openInventory(inventory);
        openInventories.add(player.getUniqueId());
    }

    public static void close(Player player) {
        if (PrestigeGUI.isOpen(player)) {
            openInventories.remove(player.getUniqueId());
        }
    }

    private static void addGlass(Inventory inventory) {
        inventory.setItem(3, GuiAssets.getGlassItem());
        inventory.setItem(5, GuiAssets.getGlassItem());
    }
}

