/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;
import org.strassburger.cookieclickerz.storage.SQLiteStorage;
import org.strassburger.cookieclickerz.storage.Storage;
import org.strassburger.cookieclickerz.util.AntiCheat;
import org.strassburger.cookieclickerz.util.ClickerManager;
import org.strassburger.cookieclickerz.util.CommandManager;
import org.strassburger.cookieclickerz.util.ConfigManager;
import org.strassburger.cookieclickerz.util.EventManager;
import org.strassburger.cookieclickerz.util.HologramManager;
import org.strassburger.cookieclickerz.util.LanguageManager;
import org.strassburger.cookieclickerz.util.Metrics;
import org.strassburger.cookieclickerz.util.VersionChecker;
import org.strassburger.cookieclickerz.util.achievements.AchievementManager;
import org.strassburger.cookieclickerz.util.cookieevents.CookieEventManager;

public final class CookieClickerZ
extends JavaPlugin {
    private static CookieClickerZ instance;
    private VersionChecker versionChecker;
    private Storage storage;
    private LanguageManager languageManager;
    private ConfigManager configManager;
    private AntiCheat antiCheat;
    private HologramManager hologramManager;
    private ClickerManager clickerManager;
    private CookieEventManager cookieEventManager;
    private AchievementManager achievementManager;
    private final boolean hasPlaceholderApi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    private final boolean hasDecentHolograms = Bukkit.getPluginManager().getPlugin("DecentHolograms") != null;

    public void onEnable() {
        instance = this;
        this.initConfig();
        this.languageManager = new LanguageManager(this);
        new CommandManager(this).registerCommands();
        new EventManager(this).registerListeners();
        this.storage = this.createStorage();
        this.storage.init();
        this.antiCheat = new AntiCheat(this);
        this.clickerManager = new ClickerManager(this);
        this.cookieEventManager = new CookieEventManager(this);
        this.achievementManager = new AchievementManager(this);
        if (this.hasDecentHolograms) {
            this.hologramManager = new HologramManager(this);
            this.hologramManager.spawnAllHolograms();
        } else {
            this.getLogger().warning("DecentHolograms not found! Holograms will not be displayed.");
        }
        this.versionChecker = new VersionChecker(this);
        this.initializeBStats();
        this.getLogger().info("CookieClickerZ enabled!");
    }

    public void onDisable() {
        this.storage.saveAllCachedData();
        this.getLogger().info("CookieClickerZ disabled!");
    }

    public static CookieClickerZ getInstance() {
        return instance;
    }

    public VersionChecker getVersionChecker() {
        return this.versionChecker;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public boolean hasPlaceholderApi() {
        return this.hasPlaceholderApi;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public AntiCheat getAntiCheat() {
        return this.antiCheat;
    }

    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    public ClickerManager getClickerManager() {
        return this.clickerManager;
    }

    public CookieEventManager getCookieEventManager() {
        return this.cookieEventManager;
    }

    public AchievementManager getAchievementManager() {
        return this.achievementManager;
    }

    private Storage createStorage() {
        this.getLogger().info("Using SQLite storage");
        return new SQLiteStorage(this);
    }

    private void initConfig() {
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        for (String file : List.of("upgrades", "prestige", "clicker")) {
            this.configManager.getCustomConfig(file);
        }
    }

    private void initializeBStats() {
        int pluginId = 25442;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("storage_type", () -> this.getConfig().getString("storage.type")));
        metrics.addCustomChart(new Metrics.SimplePie("language", () -> this.getConfig().getString("lang")));
    }

    public static String locationToString(Location location) {
        return location.getWorld().getName() + "," + location.getX() + "," + location.getY() + "," + location.getZ();
    }

    public static Location stringToLocation(String string, World world) {
        String[] parts = string.split(",");
        if (parts.length != 4) {
            return null;
        }
        try {
            double x = Double.parseDouble(parts[1]);
            double y = Double.parseDouble(parts[2]);
            double z = Double.parseDouble(parts[3]);
            return new Location(world, x, y, z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Location stringToLocation(String string) throws IllegalArgumentException {
        String[] parts = string.split(",");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid location string: " + string);
        }
        String worldName = parts[0];
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            throw new IllegalArgumentException("World not found: " + worldName);
        }
        return CookieClickerZ.stringToLocation(string, world);
    }
}

