/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.commands.MainCommand;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.commands.CommandUsageException;
import org.strassburger.cookieclickerz.commands.MainCommand.subcommands.AchievementsSubCommand;
import org.strassburger.cookieclickerz.commands.MainCommand.subcommands.ClickerSubCommand;
import org.strassburger.cookieclickerz.commands.MainCommand.subcommands.CookiesSubCommand;
import org.strassburger.cookieclickerz.commands.MainCommand.subcommands.DevSubCommand;
import org.strassburger.cookieclickerz.commands.MainCommand.subcommands.EventSubCommand;
import org.strassburger.cookieclickerz.commands.MainCommand.subcommands.HelpSubCommand;
import org.strassburger.cookieclickerz.commands.MainCommand.subcommands.NumbersSubCommand;
import org.strassburger.cookieclickerz.commands.MainCommand.subcommands.PrestigeSubCommand;
import org.strassburger.cookieclickerz.commands.MainCommand.subcommands.ReloadSubCommand;
import org.strassburger.cookieclickerz.commands.SubCommand;
import org.strassburger.cookieclickerz.util.MessageUtils;

public class MainCommandHandler
implements CommandExecutor {
    private final CookieClickerZ plugin;
    private final Map<String, SubCommand> commands = new HashMap<String, SubCommand>();

    public MainCommandHandler(CookieClickerZ plugin) {
        this.plugin = plugin;
        this.commands.put("help", new HelpSubCommand());
        this.commands.put("reload", new ReloadSubCommand(plugin));
        this.commands.put("cookies", new CookiesSubCommand(plugin));
        this.commands.put("prestige", new PrestigeSubCommand(plugin));
        this.commands.put("clicker", new ClickerSubCommand(plugin));
        this.commands.put("dev", new DevSubCommand(plugin));
        this.commands.put("events", new EventSubCommand(plugin));
        this.commands.put("achievements", new AchievementsSubCommand(plugin));
        this.commands.put("numbers", new NumbersSubCommand());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length == 0) {
            this.sendVersionMessage(sender);
            return true;
        }
        SubCommand subCommand = this.commands.get(args[0]);
        if (subCommand == null) {
            this.sendVersionMessage(sender);
            return true;
        }
        if (!subCommand.hasPermission(sender)) {
            this.throwPermissionError(sender);
            return false;
        }
        try {
            return subCommand.execute(sender, args);
        }
        catch (CommandUsageException e) {
            this.throwUsageError(sender, e.getUsage());
            return false;
        }
    }

    private void sendVersionMessage(CommandSender sender) {
        String version = this.plugin.getDescription().getVersion();
        sender.sendMessage(MessageUtils.getAndFormatMsg(true, "messages.versionMsg", "FALLBACK&7You are using version %version%", new MessageUtils.Replaceable<String>("%version%", version)));
    }

    private void throwUsageError(@NotNull CommandSender sender, String usage) {
        Component msg = MessageUtils.getAndFormatMsg(false, "usageError", "&cUsage: %usage%", new MessageUtils.Replaceable<String>("%usage%", usage));
        sender.sendMessage(msg);
    }

    private void throwPermissionError(@NotNull CommandSender sender) {
        Component msg = MessageUtils.getAndFormatMsg(false, "noPermissionError", "&cYou don't have permission to use this!", new MessageUtils.Replaceable[0]);
        sender.sendMessage(msg);
    }
}

