/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.commands.MainCommand.subcommands;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.commands.CommandUsageException;
import org.strassburger.cookieclickerz.commands.SubCommand;
import org.strassburger.cookieclickerz.storage.PlayerData;
import org.strassburger.cookieclickerz.util.MessageUtils;
import org.strassburger.cookieclickerz.util.NumFormatter;
import org.strassburger.cookieclickerz.util.achievements.Achievement;
import org.strassburger.cookieclickerz.util.achievements.AchievementCategory;
import org.strassburger.cookieclickerz.util.achievements.AchievementType;

public class AchievementsSubCommand
implements SubCommand {
    private final CookieClickerZ plugin;

    public AchievementsSubCommand(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) throws CommandUsageException {
        if (args.length < 3) {
            throw new CommandUsageException("/cc achievements [player] <get | set>");
        }
        String optionTwo = args[1];
        Player target = this.plugin.getServer().getPlayer(optionTwo);
        if (target == null) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "playerNotFound", "&cPlayer not found!", new MessageUtils.Replaceable[0]));
            return false;
        }
        PlayerData targetPlayerData = this.plugin.getStorage().load(target.getUniqueId());
        if (targetPlayerData == null) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "playerDataStorageNull", "&cPlayerDataStorage is null!", new MessageUtils.Replaceable[0]));
            return false;
        }
        if (args[2].equals("get")) {
            if (args.length < 4) {
                throw new CommandUsageException("/cc achievements [player] get <achievement>");
            }
            String optionFour = args[3];
            String achievementProgress = "0";
            AchievementType achievementType = AchievementType.getBySlug(optionFour).orElse(null);
            if (achievementType == null) {
                sender.sendMessage(MessageUtils.getAndFormatMsg(false, "achievementNotFound", "&cAchievement not found!", new MessageUtils.Replaceable[0]));
                return false;
            }
            Achievement achievement = targetPlayerData.getAchievement(achievementType).orElse(null);
            if (achievement != null) {
                achievementProgress = String.valueOf(achievement.getProgress());
                if (achievement.getType().getCategory() == AchievementCategory.COOKIES) {
                    achievementProgress = targetPlayerData.getTotalCookies().compareTo(achievement.getType().getBigIntegerGoal()) >= 0 ? NumFormatter.formatBigInt(achievement.getType().getBigIntegerGoal()) : NumFormatter.formatBigInt(targetPlayerData.getTotalCookies());
                }
            }
            sender.sendMessage(MessageUtils.getAndFormatMsg(true, "getAchievement", "&7Achievement %ac%%achievement% &7for %ac%%player%&7: %ac%%progress%&8/%ac%%goal%", new MessageUtils.Replaceable<String>("%achievement%", this.plugin.getLanguageManager().getString("achievements." + achievementType.getSlug() + ".name")), new MessageUtils.Replaceable<String>("%player%", target.getName()), new MessageUtils.Replaceable<String>("%progress%", achievementProgress), new MessageUtils.Replaceable<String>("%goal%", NumFormatter.formatBigInt(achievementType.getBigIntegerGoal()))));
            return true;
        }
        if (args[2].equals("set")) {
            if (args.length < 5) {
                throw new CommandUsageException("/cc achievements [player] set <achievement> <progress>");
            }
            String optionFour = args[3];
            String optionFive = args[4];
            int progress = Integer.parseInt(optionFive);
            AchievementType achievementType = AchievementType.getBySlug(optionFour).orElse(null);
            if (achievementType == null) {
                sender.sendMessage(MessageUtils.getAndFormatMsg(false, "achievementNotFound", "&cAchievement not found!", new MessageUtils.Replaceable[0]));
                return false;
            }
            targetPlayerData.setAchievementProgress(achievementType, progress);
            this.plugin.getStorage().save(targetPlayerData);
            sender.sendMessage(MessageUtils.getAndFormatMsg(true, "setAchievement", "&7Successfully set %ac%%player%&7's achievement %ac%%achievement% &7progress to %ac%%progress%", new MessageUtils.Replaceable<String>("%player%", target.getName()), new MessageUtils.Replaceable<String>("%achievement%", this.plugin.getLanguageManager().getString("achievements." + achievementType.getSlug() + ".name")), new MessageUtils.Replaceable<Integer>("%progress%", progress)));
            return true;
        }
        return false;
    }

    @Override
    public String getUsage() {
        return "/cc achievements [player] <get | set>";
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("cookieclickerz.admin.manageachievements");
    }
}

