/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.commands.MainCommand.subcommands;

import java.math.BigInteger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.commands.CommandUsageException;
import org.strassburger.cookieclickerz.commands.SubCommand;
import org.strassburger.cookieclickerz.storage.PlayerData;
import org.strassburger.cookieclickerz.storage.Storage;
import org.strassburger.cookieclickerz.util.MessageUtils;
import org.strassburger.cookieclickerz.util.NumFormatter;

public class CookiesSubCommand
implements SubCommand {
    private final CookieClickerZ plugin;

    public CookiesSubCommand(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) throws CommandUsageException {
        Storage storage = this.plugin.getStorage();
        if (args.length < 4) {
            throw new CommandUsageException("/cc cookies [player] <add, remove, set> [amount]");
        }
        String optionTwo = args[1];
        String optionThree = args[2];
        String amount = args[3];
        BigInteger amountNum = NumFormatter.stringToBigInteger(amount);
        if (amountNum == null) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "invalidAmount", "&cInvalid amount!", new MessageUtils.Replaceable[0]));
            return false;
        }
        if (amountNum.compareTo(BigInteger.ZERO) < 0) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "negativeAmount", "&cAmount cannot be negative!", new MessageUtils.Replaceable[0]));
            return false;
        }
        Player target = this.plugin.getServer().getPlayer(optionTwo);
        if (target == null) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "playerNotFound", "&cPlayer not found!", new MessageUtils.Replaceable[0]));
            return false;
        }
        PlayerData targetPlayerData = storage.load(target.getUniqueId());
        if (targetPlayerData == null) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "playerDataStorageNull", "&cPlayerDataStorage is null!", new MessageUtils.Replaceable[0]));
            return false;
        }
        switch (optionThree) {
            case "add": {
                targetPlayerData.setTotalCookies(targetPlayerData.getTotalCookies().add(amountNum));
                storage.save(targetPlayerData);
                sender.sendMessage(MessageUtils.getAndFormatMsg(true, "addCookies", "&7Successfully added %ac%%amount% &7cookies to %ac%%player%", new MessageUtils.Replaceable<String>("%amount%", NumFormatter.formatBigInt(amountNum)), new MessageUtils.Replaceable<String>("%player%", target.getName())));
                return true;
            }
            case "remove": {
                targetPlayerData.setTotalCookies(targetPlayerData.getTotalCookies().subtract(amountNum));
                storage.save(targetPlayerData);
                sender.sendMessage(MessageUtils.getAndFormatMsg(true, "removeCookies", "&7Successfully removed %ac%%amount% &7cookies from %ac%%player%", new MessageUtils.Replaceable<String>("%amount%", NumFormatter.formatBigInt(amountNum)), new MessageUtils.Replaceable<String>("%player%", target.getName())));
                return true;
            }
            case "set": {
                targetPlayerData.setTotalCookies(amountNum);
                storage.save(targetPlayerData);
                sender.sendMessage(MessageUtils.getAndFormatMsg(true, "setCookies", "&7Successfully set %ac%%player%&7's cookies to %ac%%amount%", new MessageUtils.Replaceable<String>("%amount%", NumFormatter.formatBigInt(amountNum)), new MessageUtils.Replaceable<String>("%player%", target.getName())));
                return true;
            }
        }
        return false;
    }

    @Override
    public String getUsage() {
        return "/cc cookies";
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("cookieclickerz.admin.managecookies");
    }
}

