/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.listeners.inventory;

import java.math.BigInteger;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.storage.PlayerData;
import org.strassburger.cookieclickerz.util.MessageUtils;
import org.strassburger.cookieclickerz.util.PrestigeData;
import org.strassburger.cookieclickerz.util.achievements.AchievementCategory;
import org.strassburger.cookieclickerz.util.achievements.AchievementType;
import org.strassburger.cookieclickerz.util.gui.GuiAssets;
import org.strassburger.cookieclickerz.util.gui.MainGUI;
import org.strassburger.cookieclickerz.util.gui.PrestigeGUI;

public class PrestigeGuiClickListener
implements Listener {
    private final CookieClickerZ plugin;

    public PrestigeGuiClickListener(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onClickEvent(InventoryClickEvent event) {
        String ciType;
        Player player = (Player)event.getWhoClicked();
        if (!PrestigeGUI.isOpen(player)) {
            return;
        }
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        String string = ciType = item != null && item.getItemMeta() != null ? (String)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "citype"), PersistentDataType.STRING) : null;
        if (ciType != null && ciType.equals("back")) {
            event.setCancelled(true);
            GuiAssets.playClickSound(player);
            PrestigeGUI.close(player);
            MainGUI.open(player);
            return;
        }
        if (event.getSlot() < 20 || event.getSlot() > 24) {
            return;
        }
        PrestigeData prestigeData = new PrestigeData(this.plugin, event.getSlot() - 19);
        PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
        if (playerData.getPrestige() >= prestigeData.getLevel()) {
            return;
        }
        if (prestigeData.getLevel() > playerData.getPrestige() + 1) {
            return;
        }
        BigInteger cost = prestigeData.getCost();
        if (playerData.getTotalCookies().compareTo(cost) < 0) {
            player.playSound(player.getLocation(), Sound.valueOf((String)this.plugin.getConfig().getString("errorSound", "ENTITY_VILLAGER_NO")), 1.0f, 1.0f);
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "notEnoughCookies", "&cYou don't have enough cookies!", new MessageUtils.Replaceable[0]));
            return;
        }
        playerData.setPrestige(prestigeData.getLevel());
        playerData.setTotalCookies(BigInteger.ZERO);
        playerData.setCookiesPerClick(BigInteger.ONE);
        playerData.setOfflineCookies(BigInteger.ZERO);
        playerData.resetUpgrades();
        this.plugin.getStorage().save(playerData);
        player.playSound(player.getLocation(), Sound.valueOf((String)this.plugin.getConfig().getString("prestigeSound", "ENTITY_PLAYER_LEVELUP")), 1.0f, 1.0f);
        player.sendMessage(MessageUtils.getAndFormatMsg(true, "prestigeSuccess", "&7You prestiged to Prestige %ac%%prestige%&7! You now have a %ac%%multiplier%x cookie multiplier!", new MessageUtils.Replaceable<Integer>("%prestige%", prestigeData.getLevel()), new MessageUtils.Replaceable<Integer>("%multiplier%", prestigeData.getMultiplier())));
        for (AchievementType achievementType : AchievementType.getByCategory(AchievementCategory.PRESTIGE)) {
            playerData.setAchievementProgress(achievementType, prestigeData.getLevel(), this.plugin);
        }
        this.plugin.getStorage().save(playerData);
        PrestigeGUI.close(player);
        PrestigeGUI.open(player);
    }
}

