/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.storage;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.util.NumFormatter;
import org.strassburger.cookieclickerz.util.achievements.Achievement;
import org.strassburger.cookieclickerz.util.achievements.AchievementType;

public final class PlayerData {
    private static final BigDecimal TOTAL_COOKIES_WEIGHT = new BigDecimal("0.4");
    private static final BigDecimal COOKIES_PER_CLICK_WEIGHT = new BigDecimal("0.3");
    private static final BigDecimal PRESTIGE_WEIGHT = new BigDecimal("0.5");
    private final String name;
    private final String uuid;
    private BigInteger totalCookies = BigInteger.ZERO;
    private int totalClicks = 0;
    private long lastLogoutTime = System.currentTimeMillis();
    private Map<String, Integer> upgrades = new HashMap<String, Integer>();
    private List<Achievement> achievements = new ArrayList<Achievement>();
    private BigInteger cookiesPerClick = BigInteger.ONE;
    private BigInteger offlineCookies = BigInteger.ZERO;
    private int prestige = 0;
    private boolean removedUpgrades = false;

    public PlayerData(String name, UUID uuid) {
        this.name = name;
        this.uuid = uuid.toString();
    }

    public String getName() {
        return this.name;
    }

    public UUID getUuid() {
        return UUID.fromString(this.uuid);
    }

    public BigInteger getTotalCookies() {
        return this.totalCookies;
    }

    public void setTotalCookies(BigInteger totalCookies) throws IllegalArgumentException {
        if (totalCookies.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("totalCookies cannot be negative");
        }
        this.totalCookies = totalCookies;
    }

    public int getTotalClicks() {
        return this.totalClicks;
    }

    public void setTotalClicks(int totalClicks) {
        this.totalClicks = totalClicks;
    }

    public long getLastLogoutTime() {
        return this.lastLogoutTime;
    }

    public void setLastLogoutTime(long lastLogoutTime) {
        this.lastLogoutTime = lastLogoutTime;
    }

    public Map<String, Integer> getUpgrades() {
        return this.upgrades;
    }

    public void setUpgrades(Map<String, Integer> upgrades) {
        this.upgrades = upgrades;
    }

    public void addUpgrade(String upgradeName, int level) {
        this.upgrades.put(upgradeName, level);
    }

    public int getUpgradeLevel(String upgradeName) {
        return this.upgrades.getOrDefault(upgradeName, 0);
    }

    public void resetUpgrades() {
        this.upgrades.clear();
        this.removedUpgrades = true;
    }

    public boolean hasRemovedUpgrades() {
        return this.removedUpgrades;
    }

    public void setHasRemovedUpgrades(boolean removedUpgrades) {
        this.removedUpgrades = removedUpgrades;
    }

    public List<Achievement> getAchievements() {
        return this.achievements;
    }

    public void setAchievements(List<Achievement> achievements) {
        this.achievements = achievements;
    }

    public Optional<Achievement> getAchievement(String achievementSlug) {
        return this.achievements.stream().filter(achievement -> achievement.getType().getSlug().equals(achievementSlug)).findFirst();
    }

    public Optional<Achievement> getAchievement(AchievementType achievementType) {
        return this.achievements.stream().filter(achievement -> achievement.getType().equals((Object)achievementType)).findFirst();
    }

    public void setAchievementProgress(String achievementSlug, int progress) throws IllegalArgumentException {
        this.setAchievementProgress(AchievementType.getBySlug(achievementSlug).orElseThrow(() -> new IllegalArgumentException("Invalid achievement slug: " + achievementSlug)), progress);
    }

    public void setAchievementProgress(AchievementType achievementType, int progress) {
        this.getAchievement(achievementType).ifPresentOrElse(achievement -> achievement.setProgress(progress), () -> this.achievements.add(new Achievement(achievementType, progress)));
    }

    public void setAchievementProgress(AchievementType achievementType, int progressAmount, CookieClickerZ plugin) throws IllegalArgumentException {
        this.getAchievement(achievementType).ifPresentOrElse(achievement -> {
            Player player = plugin.getServer().getPlayer(UUID.fromString(this.uuid));
            plugin.getAchievementManager().setAchievementProgress(player, (Achievement)achievement, progressAmount);
        }, () -> {
            Achievement achievement = new Achievement(achievementType, 0);
            this.achievements.add(achievement);
            plugin.getAchievementManager().setAchievementProgress(plugin.getServer().getPlayer(UUID.fromString(this.uuid)), achievement, progressAmount);
        });
    }

    public void progressAchievement(AchievementType achievementType, int progressAmount, CookieClickerZ plugin) {
        this.getAchievement(achievementType).ifPresentOrElse(achievement -> {
            Player player = plugin.getServer().getPlayer(UUID.fromString(this.uuid));
            plugin.getAchievementManager().progressAchievement(player, (Achievement)achievement, progressAmount);
        }, () -> {
            Achievement achievement = new Achievement(achievementType, 0);
            this.achievements.add(achievement);
            plugin.getAchievementManager().progressAchievement(plugin.getServer().getPlayer(UUID.fromString(this.uuid)), achievement, progressAmount);
        });
    }

    public void progressCookiesAchievement(AchievementType achievementType, BigInteger totalCookies, CookieClickerZ plugin) {
        this.getAchievement(achievementType).ifPresentOrElse(achievement -> {
            Player player = plugin.getServer().getPlayer(UUID.fromString(this.uuid));
            plugin.getAchievementManager().progressCookiesAchievement(player, (Achievement)achievement, totalCookies);
        }, () -> {
            Achievement achievement = new Achievement(achievementType, 0);
            this.achievements.add(achievement);
            plugin.getAchievementManager().progressCookiesAchievement(plugin.getServer().getPlayer(UUID.fromString(this.uuid)), achievement, totalCookies);
        });
    }

    public BigInteger getCookiesPerClick() {
        return this.cookiesPerClick;
    }

    public void setCookiesPerClick(BigInteger cookiesPerClick) throws IllegalArgumentException {
        if (cookiesPerClick.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("cookiesPerClick cannot be negative");
        }
        this.cookiesPerClick = cookiesPerClick;
    }

    public BigInteger getOfflineCookies() {
        return this.offlineCookies;
    }

    public void setOfflineCookies(BigInteger offlineCookies) throws IllegalArgumentException {
        if (offlineCookies.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("offlineCookies cannot be negative");
        }
        this.offlineCookies = offlineCookies;
    }

    public int getPrestige() {
        return this.prestige;
    }

    public void setPrestige(int prestige) {
        this.prestige = prestige;
    }

    public BigDecimal getScore() {
        return this.calculatePlayerScore(this.totalCookies, this.cookiesPerClick, this.prestige);
    }

    private BigDecimal calculatePlayerScore(BigInteger totalCookies, BigInteger cookiesPerClick, int prestige) {
        BigDecimal logTotalCookies = PlayerData.bigIntegerLog(totalCookies);
        BigDecimal cookiesPerClickValue = new BigDecimal(cookiesPerClick);
        return TOTAL_COOKIES_WEIGHT.multiply(logTotalCookies).add(COOKIES_PER_CLICK_WEIGHT.multiply(cookiesPerClickValue)).add(PRESTIGE_WEIGHT.multiply(new BigDecimal(prestige)));
    }

    private static BigDecimal bigIntegerLog(BigInteger value) {
        if (value.compareTo(BigInteger.ONE) <= 0) {
            return BigDecimal.ZERO;
        }
        int digits = value.toString().length() - 1;
        BigDecimal bigDecimalValue = new BigDecimal(value);
        BigDecimal firstDigitValue = bigDecimalValue.movePointLeft(digits);
        BigDecimal fractionalLog = new BigDecimal(Math.log10(firstDigitValue.doubleValue()), MathContext.DECIMAL64);
        return new BigDecimal(digits).add(fractionalLog);
    }

    public String getFormattedScore() {
        return NumFormatter.formatBigDecimal(this.getScore());
    }
}

