/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.storage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.storage.PlayerData;
import org.strassburger.cookieclickerz.storage.Storage;
import org.strassburger.cookieclickerz.util.achievements.Achievement;

public final class SQLiteStorage
extends Storage {
    private final Map<UUID, PlayerData> playerDataCache = new ConcurrentHashMap<UUID, PlayerData>();
    private static final String CSV_SEPARATOR = ",";

    public SQLiteStorage(CookieClickerZ plugin) {
        super(plugin);
    }

    @Override
    public void init() {
        try (Connection connection = this.createConnection();){
            Statement statement;
            if (connection == null) {
                return;
            }
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS players (uuid TEXT PRIMARY KEY, name TEXT, totalCookies TEXT, totalClicks INTEGER, lastLogoutTime INTEGER, cookiesPerClick TEXT, offlineCookies TEXT,prestige INTEGER DEFAULT 0)");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to create players table in SQLite database: " + e.getMessage());
            }
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS upgrades (uuid TEXT, upgrade_name TEXT, level INTEGER, PRIMARY KEY (uuid, upgrade_name), FOREIGN KEY (uuid) REFERENCES players(uuid))");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to create upgrades table in SQLite database: " + e.getMessage());
            }
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS achievements (uuid TEXT, achievement_name TEXT, progress INTEGER, PRIMARY KEY (uuid, achievement_name), FOREIGN KEY (uuid) REFERENCES players(uuid))");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to create achievements table in SQLite database: " + e.getMessage());
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to initialize SQLite database: " + e.getMessage());
        }
    }

    private Connection createConnection() {
        try {
            CookieClickerZ plugin = this.getPlugin();
            String pluginFolderPath = plugin.getDataFolder().getPath();
            return DriverManager.getConnection("jdbc:sqlite:" + pluginFolderPath + "/userData.db");
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to create connection to SQLite database: " + e.getMessage());
            return null;
        }
    }

    @Override
    public void save(PlayerData playerData) {
        if (playerData == null) {
            return;
        }
        if (this.shouldUsePlayerCache() && this.playerDataCache.containsKey(playerData.getUuid())) {
            this.playerDataCache.put(playerData.getUuid(), playerData);
            return;
        }
        String query = "INSERT OR REPLACE INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                return;
            }
            try (PreparedStatement statement = connection.prepareStatement("INSERT OR REPLACE INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                statement.setString(1, playerData.getUuid().toString());
                statement.setString(2, playerData.getName());
                statement.setString(3, playerData.getTotalCookies().toString());
                statement.setInt(4, playerData.getTotalClicks());
                statement.setLong(5, playerData.getLastLogoutTime());
                statement.setString(6, playerData.getCookiesPerClick().toString());
                statement.setString(7, playerData.getOfflineCookies().toString());
                statement.setInt(8, playerData.getPrestige());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to save player data to SQLite database: " + e.getMessage());
            }
            this.saveUpgrades(connection, playerData);
            this.saveAchievements(connection, playerData);
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to save player data to SQLite database: " + e.getMessage());
        }
    }

    private void saveUpgrades(Connection connection, PlayerData playerData) throws SQLException {
        if (playerData.hasRemovedUpgrades()) {
            String deleteQuery = "DELETE FROM achievements WHERE uuid = ?";
            try (PreparedStatement deleteStatement = connection.prepareStatement("DELETE FROM achievements WHERE uuid = ?");){
                deleteStatement.setString(1, playerData.getUuid().toString());
                deleteStatement.executeUpdate();
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to delete upgrades for player: " + e.getMessage());
                throw e;
            }
        }
        String query = "INSERT INTO upgrades (uuid, upgrade_name, level) VALUES (?, ?, ?) ON CONFLICT(uuid, upgrade_name) DO UPDATE SET level = excluded.level";
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO upgrades (uuid, upgrade_name, level) VALUES (?, ?, ?) ON CONFLICT(uuid, upgrade_name) DO UPDATE SET level = excluded.level");){
            for (Map.Entry<String, Integer> entry : playerData.getUpgrades().entrySet()) {
                statement.setString(1, playerData.getUuid().toString());
                statement.setString(2, entry.getKey());
                statement.setInt(3, entry.getValue());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to save upgrades for player: " + e.getMessage());
            throw e;
        }
    }

    private void saveAchievements(Connection connection, PlayerData playerData) throws SQLException {
        String query = "INSERT INTO achievements (uuid, achievement_name, progress) VALUES (?, ?, ?) ON CONFLICT(uuid, achievement_name) DO UPDATE SET progress = excluded.progress";
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO achievements (uuid, achievement_name, progress) VALUES (?, ?, ?) ON CONFLICT(uuid, achievement_name) DO UPDATE SET progress = excluded.progress");){
            for (Achievement achievement : playerData.getAchievements()) {
                statement.setString(1, playerData.getUuid().toString());
                statement.setString(2, achievement.getType().getSlug());
                statement.setInt(3, achievement.getProgress());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to save achievements for player: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public PlayerData load(UUID uuid) {
        if (this.shouldUsePlayerCache() && this.playerDataCache.containsKey(uuid)) {
            return this.playerDataCache.get(uuid);
        }
        PlayerData playerData = this.loadPlayerData(uuid);
        if (playerData != null) {
            this.loadUpgrades(uuid, playerData);
            this.loadAchievements(uuid, playerData);
        }
        if (this.shouldUsePlayerCache()) {
            this.playerDataCache.put(uuid, playerData);
            if (this.playerDataCache.size() > this.getMaxCacheSize()) {
                this.saveAllCachedData();
            }
        }
        return playerData;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private PlayerData loadPlayerData(UUID uuid) {
        String query = "SELECT * FROM players WHERE uuid = ?";
        try (Connection connection = this.createConnection();){
            PlayerData playerData;
            block26: {
                ResultSet resultSet;
                PreparedStatement statement;
                block22: {
                    PlayerData playerData2;
                    block25: {
                        Player player;
                        block23: {
                            PlayerData playerData3;
                            block24: {
                                if (connection == null) {
                                    PlayerData playerData4 = null;
                                    return playerData4;
                                }
                                statement = connection.prepareStatement("SELECT * FROM players WHERE uuid = ?");
                                try {
                                    statement.setString(1, uuid.toString());
                                    resultSet = statement.executeQuery();
                                    if (resultSet.next()) break block22;
                                    player = Bukkit.getPlayer((UUID)uuid);
                                    if (player != null) break block23;
                                    playerData3 = null;
                                    if (statement == null) break block24;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (statement != null) {
                                            try {
                                                statement.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (SQLException e) {
                                        this.getPlugin().getLogger().severe("Failed to load player data from SQLite database: " + e.getMessage());
                                        PlayerData playerData5 = null;
                                        return playerData5;
                                    }
                                }
                                statement.close();
                            }
                            return playerData3;
                        }
                        PlayerData newPlayerData = new PlayerData(player.getName(), uuid);
                        this.save(newPlayerData);
                        playerData2 = newPlayerData;
                        if (statement == null) break block25;
                        statement.close();
                    }
                    return playerData2;
                }
                PlayerData playerData6 = new PlayerData(resultSet.getString("name"), uuid);
                playerData6.setTotalCookies(new BigInteger(resultSet.getString("totalCookies")));
                playerData6.setTotalClicks(resultSet.getInt("totalClicks"));
                playerData6.setLastLogoutTime(resultSet.getLong("lastLogoutTime"));
                playerData6.setCookiesPerClick(new BigInteger(resultSet.getString("cookiesPerClick")));
                playerData6.setOfflineCookies(new BigInteger(resultSet.getString("offlineCookies")));
                playerData6.setPrestige(resultSet.getInt("prestige"));
                playerData = playerData6;
                if (statement == null) break block26;
                statement.close();
            }
            return playerData;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to load player data from SQLite database: " + e.getMessage());
            return null;
        }
    }

    private void loadUpgrades(UUID uuid, PlayerData playerData) {
        String query = "SELECT * FROM upgrades WHERE uuid = ?";
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                return;
            }
            try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM upgrades WHERE uuid = ?");){
                statement.setString(1, uuid.toString());
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String upgradeName = resultSet.getString("upgrade_name");
                    int level = resultSet.getInt("level");
                    playerData.addUpgrade(upgradeName, level);
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to load upgrades from SQLite database: " + e.getMessage());
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to load upgrades from SQLite database: " + e.getMessage());
        }
    }

    private void loadAchievements(UUID uuid, PlayerData playerData) {
        String query = "SELECT * FROM achievements WHERE uuid = ?";
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                return;
            }
            try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM achievements WHERE uuid = ?");){
                statement.setString(1, uuid.toString());
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String achievementSlug = resultSet.getString("achievement_name");
                    int progress = resultSet.getInt("progress");
                    playerData.setAchievementProgress(achievementSlug, progress);
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to load achievements from SQLite database: " + e.getMessage());
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to load achievements from SQLite database: " + e.getMessage());
        }
    }

    @Override
    public PlayerData load(String uuid) {
        return this.load(UUID.fromString(uuid));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String export(String fileName) {
        String filePath = this.getPlugin().getDataFolder().getPath() + "/" + fileName + ".csv";
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                String string = null;
                return string;
            }
            try (Statement statement = connection.createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT * FROM players");
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
                    while (resultSet.next()) {
                        String line = resultSet.getString("uuid") + CSV_SEPARATOR + resultSet.getString("name") + CSV_SEPARATOR + resultSet.getString("totalCookies") + CSV_SEPARATOR + resultSet.getInt("totalClicks") + CSV_SEPARATOR + resultSet.getLong("lastLogoutTime") + CSV_SEPARATOR + resultSet.getString("cookiesPerClick") + CSV_SEPARATOR + resultSet.getString("offlineCookies") + CSV_SEPARATOR + resultSet.getInt("prestige");
                        writer.write(line);
                        writer.newLine();
                    }
                    return filePath;
                }
            }
            catch (IOException | SQLException e) {
                this.getPlugin().getLogger().severe("Failed to export player data to CSV file: " + e.getMessage());
                String string = null;
                if (connection == null) return string;
                connection.close();
                return string;
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to export player data to CSV file: " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importData(String fileName) {
        String filePath = this.getPlugin().getDataFolder().getPath() + "/" + fileName;
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] data = line.split(CSV_SEPARATOR);
                if (data.length != 8) {
                    this.getPlugin().getLogger().severe("Invalid CSV format.");
                    continue;
                }
                try {
                    Connection connection;
                    block26: {
                        connection = this.createConnection();
                        if (connection != null) break block26;
                        if (connection == null) return;
                        connection.close();
                        return;
                    }
                    try {
                        try {
                            PreparedStatement statement = connection.prepareStatement("INSERT OR REPLACE INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                            try {
                                statement.setString(1, data[0]);
                                statement.setString(2, data[1]);
                                statement.setString(3, data[2]);
                                statement.setInt(4, Integer.parseInt(data[3]));
                                statement.setLong(5, Long.parseLong(data[4]));
                                statement.setString(6, data[5]);
                                statement.setString(7, data[6]);
                                statement.setInt(8, Integer.parseInt(data[7]));
                                statement.executeUpdate();
                            }
                            finally {
                                if (statement == null) continue;
                                statement.close();
                            }
                        }
                        catch (SQLException e) {
                            this.getPlugin().getLogger().severe("Failed to import player data from CSV file: " + e.getMessage());
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().severe("Failed to import player data from CSV file: " + e.getMessage());
                }
            }
            return;
        }
        catch (IOException e) {
            this.getPlugin().getLogger().severe("Failed to read CSV file: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PlayerData> getAllPlayers() {
        ArrayList<PlayerData> players = new ArrayList<PlayerData>();
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                ArrayList<PlayerData> arrayList = players;
                return arrayList;
            }
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM players");
            while (rs.next()) {
                PlayerData player = new PlayerData(rs.getString("name"), UUID.fromString(rs.getString("uuid")));
                player.setTotalCookies(new BigInteger(rs.getString("totalCookies")));
                player.setTotalClicks(rs.getInt("totalClicks"));
                player.setLastLogoutTime(rs.getLong("lastLogoutTime"));
                player.setCookiesPerClick(new BigInteger(rs.getString("cookiesPerClick")));
                player.setOfflineCookies(new BigInteger(rs.getString("offlineCookies")));
                player.setPrestige(rs.getInt("prestige"));
                players.add(player);
            }
            return players;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to load upgrades from SQLite database: " + e.getMessage());
        }
        return players;
    }

    @Override
    public void saveAllCachedData() {
        if (this.playerDataCache.isEmpty()) {
            return;
        }
        HashMap<UUID, PlayerData> snapshot = new HashMap<UUID, PlayerData>(this.playerDataCache);
        this.playerDataCache.clear();
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                return;
            }
            connection.setAutoCommit(false);
            try (PreparedStatement psPlayers = connection.prepareStatement("INSERT OR REPLACE INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                for (PlayerData data : snapshot.values()) {
                    psPlayers.setString(1, data.getUuid().toString());
                    psPlayers.setString(2, data.getName());
                    psPlayers.setString(3, data.getTotalCookies().toString());
                    psPlayers.setInt(4, data.getTotalClicks());
                    psPlayers.setLong(5, data.getLastLogoutTime());
                    psPlayers.setString(6, data.getCookiesPerClick().toString());
                    psPlayers.setString(7, data.getOfflineCookies().toString());
                    psPlayers.setInt(8, data.getPrestige());
                    psPlayers.addBatch();
                }
                psPlayers.executeBatch();
            }
            try (PreparedStatement psUpgrades = connection.prepareStatement("INSERT INTO upgrades (uuid, upgrade_name, level) VALUES (?, ?, ?) ON CONFLICT(uuid, upgrade_name) DO UPDATE SET level = excluded.level");){
                for (PlayerData data : snapshot.values()) {
                    for (Map.Entry<String, Integer> upgrade : data.getUpgrades().entrySet()) {
                        psUpgrades.setString(1, data.getUuid().toString());
                        psUpgrades.setString(2, upgrade.getKey());
                        psUpgrades.setInt(3, upgrade.getValue());
                        psUpgrades.addBatch();
                    }
                }
                psUpgrades.executeBatch();
            }
            try (PreparedStatement psAchievements = connection.prepareStatement("INSERT INTO achievements (uuid, achievement_name, progress) VALUES (?, ?, ?) ON CONFLICT(uuid, achievement_name) DO UPDATE SET progress = excluded.progress");){
                for (PlayerData data : snapshot.values()) {
                    for (Achievement achievement : data.getAchievements()) {
                        psAchievements.setString(1, data.getUuid().toString());
                        psAchievements.setString(2, achievement.getType().getSlug());
                        psAchievements.setInt(3, achievement.getProgress());
                        psAchievements.addBatch();
                    }
                }
                psAchievements.executeBatch();
            }
            connection.commit();
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to flush player data cache: " + e.getMessage());
        }
    }
}

