/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.storage;

import java.util.List;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.storage.PlayerData;

public abstract class Storage {
    private final CookieClickerZ plugin;

    public Storage(CookieClickerZ plugin) {
        this.plugin = plugin;
        long saveInterval = (long)plugin.getConfig().getInt("enabled.saveInterval", 60) * 20L;
        new BukkitRunnable(){

            public void run() {
                Storage.this.saveAllCachedData();
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, saveInterval, saveInterval);
    }

    protected CookieClickerZ getPlugin() {
        return this.plugin;
    }

    protected boolean shouldUsePlayerCache() {
        return this.getPlugin().getConfig().getBoolean("playerCache.enabled", true);
    }

    protected int getMaxCacheSize() {
        return this.getPlugin().getConfig().getInt("playerCache.maxSize", 1000);
    }

    public abstract void init();

    public abstract void save(PlayerData var1);

    public abstract PlayerData load(String var1);

    public abstract PlayerData load(UUID var1);

    public abstract String export(String var1);

    public abstract void importData(String var1);

    public abstract List<PlayerData> getAllPlayers();

    public abstract void saveAllCachedData();
}

