/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.util;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.util.ConfigManager;

public class ClickerManager {
    private final CookieClickerZ plugin;

    public ClickerManager(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    public void addClicker(String clicker, String name) {
        ConfigManager configManager = this.plugin.getConfigManager();
        FileConfiguration clickerConfig = configManager.getCustomConfig("clicker");
        if (clickerConfig == null) {
            return;
        }
        clickerConfig.set(name + ".name", (Object)name);
        clickerConfig.set(name + ".location", (Object)clicker);
        configManager.saveCustomConfig("clicker", clickerConfig);
        if (this.plugin.getHologramManager() != null) {
            this.plugin.getHologramManager().spawnHologram(new Clicker(name, CookieClickerZ.stringToLocation(clicker)));
        }
    }

    public void addClicker(Location clicker, String name) {
        this.addClicker(CookieClickerZ.locationToString(clicker), name);
    }

    public boolean isClicker(String clicker) {
        ConfigManager configManager = this.plugin.getConfigManager();
        FileConfiguration clickerConfig = configManager.getCustomConfig("clicker");
        if (clickerConfig == null) {
            return false;
        }
        ArrayList clickerNames = new ArrayList(clickerConfig.getKeys(false));
        return clickerNames.contains(clicker);
    }

    public boolean isClicker(Location location) {
        ConfigManager configManager = this.plugin.getConfigManager();
        FileConfiguration clickerConfig = configManager.getCustomConfig("clicker");
        if (clickerConfig == null) {
            return false;
        }
        String locationString = CookieClickerZ.locationToString(location);
        for (String key : clickerConfig.getKeys(false)) {
            String storedLocation = clickerConfig.getString(key + ".location");
            if (!locationString.equals(storedLocation)) continue;
            return true;
        }
        return false;
    }

    public void removeClicker(String name) {
        ConfigManager configManager = this.plugin.getConfigManager();
        FileConfiguration clickerConfig = configManager.getCustomConfig("clicker");
        if (clickerConfig == null) {
            return;
        }
        clickerConfig.set(name, null);
        configManager.saveCustomConfig("clicker", clickerConfig);
        if (this.plugin.getHologramManager() != null) {
            this.plugin.getHologramManager().removeHologram(name);
        }
    }

    public Clicker getClicker(String name) {
        return new Clicker(name, this.getClickerLocation(name));
    }

    public List<Clicker> getClickers() {
        ArrayList<Clicker> clickers = new ArrayList<Clicker>();
        for (String name : this.getClickerKeys()) {
            clickers.add(this.getClicker(name));
        }
        return clickers;
    }

    @NotNull
    public List<String> getClickerKeys() {
        ConfigManager configManager = this.plugin.getConfigManager();
        FileConfiguration clickerConfig = configManager.getCustomConfig("clicker");
        if (clickerConfig == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(clickerConfig.getKeys(false));
    }

    public String getClickerLocationAsString(String name) {
        ConfigManager configManager = this.plugin.getConfigManager();
        FileConfiguration clickerConfig = configManager.getCustomConfig("clicker");
        if (clickerConfig == null) {
            return null;
        }
        return clickerConfig.getString(name + ".location");
    }

    public Location getClickerLocation(String name) {
        String locationString = this.getClickerLocationAsString(name);
        if (locationString == null) {
            return null;
        }
        return CookieClickerZ.stringToLocation(locationString);
    }

    public static class Clicker {
        private final String name;
        private final Location location;

        public Clicker(String name, Location location) {
            this.name = name;
            this.location = location;
        }

        public String getName() {
            return this.name;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

