/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.util;

import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.strassburger.cookieclickerz.CookieClickerZ;

public class ConfigManager {
    private final CookieClickerZ plugin;

    public ConfigManager(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    public FileConfiguration getClickerConfig() {
        return this.getCustomConfig("clicker");
    }

    public FileConfiguration getUpgradesConfig() {
        return this.getCustomConfig("upgrades");
    }

    public FileConfiguration getPrestigeConfig() {
        return this.getCustomConfig("prestige");
    }

    public FileConfiguration getCustomConfig(String fileName) {
        File configFile = new File(this.plugin.getDataFolder(), (String)(fileName.contains(".yml") ? fileName : fileName + ".yml"));
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            this.plugin.saveResource(fileName + ".yml", false);
        }
        return YamlConfiguration.loadConfiguration((File)configFile);
    }

    public void saveCustomConfig(String fileName, FileConfiguration config) {
        Object name = fileName.contains(".yml") ? fileName : fileName + ".yml";
        File configFile = new File(this.plugin.getDataFolder(), (String)name);
        try {
            config.save(configFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Could not save " + (String)name + ": " + e.getMessage());
        }
    }
}

