/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.util;

import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.util.ClickerManager;
import org.strassburger.cookieclickerz.util.MessageUtils;

public class HologramManager {
    private final CookieClickerZ plugin;

    public HologramManager(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    public void spawnAllHolograms() {
        this.plugin.getClickerManager().getClickers().forEach(this::spawnHologram);
    }

    public void spawnHologram(@NotNull ClickerManager.Clicker clicker) {
        if (!this.plugin.getConfig().getBoolean("hologram")) {
            return;
        }
        if (DHAPI.getHologram((String)("cc_" + clicker.getName())) != null) {
            return;
        }
        double offset = this.plugin.getLanguageManager().getDouble("clickerHologramOffset");
        Location location = clicker.getLocation().clone().add(0.5, offset, 0.5);
        List lines = this.plugin.getLanguageManager().getStringList("clickerHologram").stream().map(x$0 -> MessageUtils.replacePlaceholders(x$0, new MessageUtils.Replaceable[0])).map(MessageUtils::convertToLegacy).collect(Collectors.toList());
        Hologram hologram = DHAPI.createHologram((String)("cc_" + clicker.getName()), (Location)location);
        for (String line : lines) {
            DHAPI.addHologramLine((Hologram)hologram, (String)line);
        }
    }

    public void removeHologram(@NotNull String clickerName) {
        Hologram hologram = DHAPI.getHologram((String)("cc_" + clickerName));
        if (hologram != null) {
            DHAPI.removeHologram((String)("cc_" + clickerName));
        }
    }

    public void removeHologram(@NotNull ClickerManager.Clicker clicker) {
        this.removeHologram(clicker.getName());
    }
}

