/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.util;

import java.math.BigInteger;
import org.bukkit.configuration.file.FileConfiguration;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.util.NumFormatter;

public class PrestigeData {
    private final int level;
    private final String name;
    private final BigInteger cost;
    private final int multiplier;

    public PrestigeData(CookieClickerZ plugin, int level) {
        FileConfiguration config = plugin.getConfigManager().getPrestigeConfig();
        if (level == 0) {
            this.level = 0;
            this.name = "None";
            this.cost = BigInteger.ZERO;
            this.multiplier = 1;
            return;
        }
        this.level = level;
        this.name = config.getString("levels." + level + ".name");
        this.cost = NumFormatter.stringToBigInteger(config.getString("levels." + level + ".cost", "0"));
        this.multiplier = config.getInt("levels." + level + ".multiplier");
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public BigInteger getCost() {
        return this.cost;
    }

    public int getMultiplier() {
        return this.multiplier;
    }
}

